<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Product;
use App\Models\Category;
use Hash;
use Auth;

class ImageController extends Controller
{
	public function bulk_image_upload(Request $request){
		return view('admin.bulk_image_upload');
	}

	public function bulk_image_upload_store(Request $request){

		$image = $request->file('file');
        //$imageName = strtotime(now()).rand(11111,99999).'.' . $image->getClientOriginalExtension();
        $imageName = $image->getClientOriginalName();

        $image->move(public_path() . '/'.$request->uploadlocation.'/', $imageName);
        
        return response()->json(['success'=>'upload_success']);
	}

	public function category_banner_upload($id = null, Request $request){

		$id = base64_decode($id);
		$dataDetails  = Category::where('id',$id)->first();

		if($request->isMethod('POST')){
			//dd($request);
			$imagefile=$request->file("image");
            if (isset($imagefile)){
                $imageName = strtotime(now()).rand(11111,99999).'-banner.'.$imagefile->getClientOriginalExtension();
                $imagefile->move(public_path() . '/uploaded/banner/', $imageName);
            }

            if(isset($imagefile)){
                $update_arr['image'] = $imageName;
            }

            if(Category::where(['id' => $request->formid])->update($update_arr)){
                $request->session()->flash('alert-success', 'Catgory successfully updated.');
                return redirect()->back();
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }

		}

		return view('admin.category_banner_upload', ['request' => $request, 'dataDetails' => $dataDetails]);
	}
}