<?php

namespace App\Http\Controllers\site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Response;
use App\Mail\EmailPlaceOrder;
use App\Mail\EmailPlaceOrderAdmin;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\Currency;
use App\Models\OrderCurrency;
use App\Models\Country;
use App\Models\City;
use App\Models\CountryLocation;
use App\Models\UserAddress;
use App\Models\OrderMessage;
use App\Models\Coupon;
use App\Models\AppliedCoupon;
use App\Models\Promotional;
use Auth;
use DB;


class PaypalController extends Controller
{
	public function __construct(){
        //$this->middleware('auth');
        $users = new User;
    }

    public function orderPlacedDetails(Request $request){
    		if( Session::has('Cart.order_details') ) {

                $userid =  Auth::user()->id;

                $c_data = Session::get('Cart.order_details');
                
                
                $shipping_price = 0;
                if( $c_data != null && isset($c_data['item_dtl']) ){
                    foreach ($c_data['item_dtl'] as $key => $value) {
                        $shipping_price = $shipping_price + $value['ship_price'];
                    }
                }

                
                if(Session::get('Cart.order_id') != null){
                    $order_id  = Session::get('Cart.order_id');
                }else{
                    $order_id  = $c_data['order_id'];
                }

                $unique_order_id           = 'GBWW';
                //$order_id                  = Session::get('Cart.order_id');
                $delivery_address_id       = Session::get('delivery_address_id');
                $billing_address_id        = Session::get('billing_address_id');
                $order_details             = Session::get('Cart.order_details');
                $coupon_id                 = Session::get('couponid');

                //dd($delivery_address_id);

                $coupon_discount_amount    = 0;
                if( Session::has('coupon_discount_amount') ) {
                    $coupon_discount_amount= Session::get('coupon_discount_amount');

                    AppliedCoupon::where([
                                        'order_id'        => $order_id,
                                        'coupon_id'       => $coupon_id
                                    ])
                                    ->update([
                                        'coupon_discount_amount' => $coupon_discount_amount
                                    ]);
                }

                $get_date_time             = @$this->get_date_time();
                $get_date_time             = isset($get_date_time)?$get_date_time:date('Y-m-d H:i:s');

                if( !empty($order_details) ) {
                    $unique_order_id       = $order_details['unique_order_id'];
                }

                $delivery_user_name = ''; $delivery_address = ''; $delivery_mobile = ''; $delivery_email = ''; $delivery_country = ''; $delivery_pincode = '';
                $delivery_state = ''; $delivery_city = ''; $delivery_country_id = '';
                if( $delivery_address_id != 0 ) {
                    $delivery_address_detail = UserAddress::where([
                                                                'id'          => $delivery_address_id,
                                                                'user_id'     => Auth::user()->id,
                                                                'address_type'=> 'DA'
                                                            ])
                                                            ->first();

                    if( $delivery_address_detail != null ) {
                        $delivery_user_name = isset($delivery_address_detail->name)?$delivery_address_detail->name:NULL;
                        $delivery_address   = isset($delivery_address_detail->address)?$delivery_address_detail->address:NULL;
                        $delivery_mobile    = isset($delivery_address_detail->mobile)?$delivery_address_detail->mobile:NULL;
                        $delivery_pincode   = isset($delivery_address_detail->pincode)?$delivery_address_detail->pincode:NULL;
                        //echo "==>".$delivery_email     = isset($delivery_address_detail->email)?$delivery_address_detail->email:NULL;
                        $delivery_email   = isset($delivery_address_detail->email)?$delivery_address_detail->email:NULL;
                        $delivery_country   = isset($delivery_address_detail->country_name)?$delivery_address_detail->country_name:NULL;
                        $delivery_state     = isset($delivery_address_detail->state_name)?$delivery_address_detail->state_name:NULL;
                        $delivery_city      = isset($delivery_address_detail->city_name)?$delivery_address_detail->city_name:NULL;
                        $delivery_country_id   = isset($delivery_address_detail->country_id)?$delivery_address_detail->country_id:110;
                    }
                }

                $billing_user_name = ''; $billing_address = ''; $billing_mobile = ''; $billing_email = ''; $billing_pincode = ''; $billing_country = ''; $billing_state = ''; $billing_city = ''; $billing_country_id = '';
                if( $billing_address_id != 0 ) {
                    $billing_address_detail = UserAddress::where([
                                                                'id'          => $billing_address_id,
                                                                'user_id'     => Auth::user()->id,
                                                                'address_type'=> 'BA'
                                                            ])
                                                            ->first();
                    if( $billing_address_detail != null ) {
                        $billing_user_name  = isset($billing_address_detail->name)?$billing_address_detail->name:NULL;
                        $billing_address    = isset($billing_address_detail->address)?$billing_address_detail->address:NULL;
                        $billing_mobile     = isset($billing_address_detail->mobile)?$billing_address_detail->mobile:NULL;
                        //echo "===>".$billing_email      = isset($billing_address_detail->email)?$billing_address_detail->email:NULL;
                        $billing_pincode    = isset($billing_address_detail->pincode)?$billing_address_detail->pincode:'';
                        /*$billing_country    = isset($billing_address_detail->country->name)?$billing_address_detail->country->name:'';*/
                        $billing_country    = isset($billing_address_detail->country_name)?$billing_address_detail->country_name:'';
                        $billing_state      = isset($billing_address_detail->state_name)?$billing_address_detail->state_name:'';
                        /*$billing_city       = isset($billing_address_detail->city->name)?$billing_address_detail->city->name:'';*/
                        $billing_city       = isset($billing_address_detail->city_name)?$billing_address_detail->city_name:'';
                        $billing_country_id   = isset($billing_address_detail->country_id)?$billing_address_detail->country_id:110;
                    }
                }

                $ordered_amount = 0; $final_ordered_amount = 0; $final_ordered_amount_discounted = 0;

                $ordered_amount                  = $c_data['total_cart_price'] + $shipping_price;
                $final_ordered_amount            = $c_data['total_cart_price'] + $shipping_price;
                $final_ordered_amount_discounted = ($c_data['total_cart_price'] + $shipping_price) - $coupon_discount_amount;

                //dd($final_ordered_amount_discounted);
                //dd($order_id);

                $abc = Order::where([
                            'id'      => $order_id,
                            'user_id' => Auth::user()->id,
                            'type'    => 'cart'
                        ])
                        ->update([
                            'payment_method'        => '0',
                            'payment_status'        => 'P',
                            //'order_status'          => 'OP',
                            //'type'                  => 'order',
                            'delivery_pincode'      => $delivery_pincode,
                            'delivery_country'      => $delivery_country,
                            'delivery_state'        => $delivery_state,
                            'delivery_city'         => $delivery_city,
                            'delivery_user_name'    => $delivery_user_name,
                            'delivery_address'      => $delivery_address,
                            'delivery_mobile'       => $delivery_mobile,
                            'delivery_email'      => $delivery_email,
                            'billing_pincode'       => $billing_pincode,
                            'billing_country'       => $billing_country,
                            'billing_state'         => $billing_state,
                            'billing_city'          => $billing_city,
                            'billing_user_name'     => $billing_user_name,
                            'billing_address'       => $billing_address,
                            'billing_mobile'        => $billing_mobile,
                            //'billing_email'       => $billing_email,
                            'purchase_date'         => $get_date_time,
                            'final_ordered_amount'  => $final_ordered_amount_discounted
                        ]);

                if( Session::has('currency') ) {
                    $currency = Session::get('currency');
                }
                else{
                    $currency = 'USD';
                }
                $currency_data = Currency::where(['currency' => $currency, 'is_block' => 'N'])->first();
                if( $currency_data->count() > 0 ) {
                    $order_currency['order_id']        = $order_id;
                    $order_currency['order_currency']  = $currency_data->currency;
                    $order_currency['conversion_rate'] = $currency_data->value;
                    $order_currency['html_code']       = $currency_data->html_code;
                    $ordetail_submit                   = OrderCurrency::create($order_currency);
                }

                
                $user_array = Auth::user();

                $orderCnt = Order::where(['id'=> $order_id])->count();
                if($orderCnt > 0){
                    $encoded_order_id = base64_encode($order_id);
                    $custom_value   = $encoded_order_id."|".$unique_order_id."|".$userid;

                    $itemDtlString = '';
                    $orderDetails = $this->order_dtl($order_id);

                    foreach ($orderDetails as $data) {
                        //like 218(0):1,2021-06-25##
                        $createString = $data['product_id'].'('.$data['product_attr_id'].'):'.$data['qty'].','.$data['delivery_date'].'##';
                        $itemDtlString = $itemDtlString . $createString;
                    }

                    $orderCustomString = $custom_value .'|'. base64_encode(substr($itemDtlString, 0, -2));

                }else{
                    $custom_value = 'WRONG';
                    $orderCustomString = '';
                    //abort('404');
                    //die();
                }

                $customerNameString = trim($billing_user_name);

                if (strpos($customerNameString, ' ') !== false) {
                    //echo 'has spaces, but not at beginning or end';
                    $customerNameStringArray = explode(" ", $customerNameString, 2);
                    $fname = $customerNameStringArray[0];
                    $lname = $customerNameStringArray[1];
                }else{
                    $fname = $customerNameString;
                    $lname = '';
                }

                $customerNameStringArray = explode(" ", $customerNameString, 2);

                $customer_email = Auth::user()->email;
                $customer_address = $billing_address.','.$billing_city;

                $customerCountry = Country::where(['id'=>$billing_country_id])->first();

                $deliveryCountry = Country::where(['id'=>$delivery_country_id])->first();

                $customer_mobileno = str_replace("+","",$billing_mobile);
                $customer_mobileno = str_replace("-","",$customer_mobileno);
                $customer_mobileno = str_replace(" ","",$customer_mobileno);

                //base64_encode($unique_order_id)


                //TEST MAIL WITHOUT SUCCESS
                // $order_data = Order::find($order_id);
                // $order_unique_id = $order_data->unique_order_id;
                // $user_array = Auth::user();
                // $order_data_1 = $this->order_dtl($order_data->id);
                // $main_order_data = Order::where(['id'=>$order_data->id])->first();
                // Mail::to(Auth::user()->email)->queue(new EmailPlaceOrder($user_array,$order_data_1,$main_order_data));

                 

                $responseString = $fname.'*|*'.$lname .'*|*'. $customer_address .'*|*'. $billing_pincode .'*|*'. $customerCountry->country_code .'*|*'. $customer_email .'*|*'. $customer_mobileno .'*|*'. $delivery_user_name .'*|*'. $delivery_address .'*|*'. $delivery_city .'*|*'. $delivery_state .'*|*'. $delivery_pincode .'*|*'. $deliveryCountry->country_code .'*|*'. $final_ordered_amount_discounted .'*|*'.$unique_order_id .'*|*'. $orderCustomString;

                //$responseString = $billing_user_name .'*|*'. $billing_address .'*|*'. $final_ordered_amount_discounted .'*|*'.base64_encode($unique_order_id) .'*|*'. $delivery_address;

                echo $responseString;
                

            }else{
                echo "none";
            }
    }

    public function paywithpaypalSuccess(Request $request) {

        $getdata = json_decode($request->getContent(), true);

        $uorderID = $getdata['uorderID'];

        if($uorderID != '' && $getdata['status'] == 'COMPLETED'){

            $getOrder = Order::where(['unique_order_id' => $request->get('uorderID')])->first();
            $order_id = $getOrder->id;

            $appliedDtl = AppliedCoupon::where('order_id', $order_id)->first();
            if( $appliedDtl != null ){
                $couponDtl = Coupon::where('id', $appliedDtl->coupon_id)->first();
                if($couponDtl->promotion == 'Y'){
                    Promotional::where([
                        'email'  => Auth::user()->email,
                        'coupon_code' => $couponDtl->id
                    ])
                    ->update(['is_used' => 'Y']);
                }
            }

            $order = Order::where([
                        'id'      => $order_id,
                        'user_id' => Auth::user()->id,
                        'type'    => 'cart'
                    ]);
            $order->update([
                            'payment_method'=> '2',
                            'payment_status'=> 'C',
                            'order_status'  => 'OP',
                            'type'          => 'order',
                            'txn_id'        => $getdata['txnId']
                        ]);

            OrderDetail::where(['order_id'  => $order_id])->update(['order_status' => 'OP']);

            $order_data = Order::find($order_id);
            $order_unique_id = $order_data->unique_order_id;

            $user_array = Auth::user();

            $order_data_1 = $this->order_dtl($order_data->id);

            

            /*Send email to user */
            $main_order_data = Order::where(['id'=>$order_data->id])->first();
            //dd($main_order_data->order_message);

            try{
            Mail::to(Auth::user()->email)->queue(new EmailPlaceOrder($user_array,$order_data_1,$main_order_data));

            //Order send BCC Lists
            $bccemails = ['auto-update@germanflorist.de'];
            Mail::bcc($bccemails)->queue(new EmailPlaceOrder($user_array,$order_data_1,$main_order_data));
            }
            catch(\Exception $e){
                // Get error here
            }

            Session::forget(['Cart.order_id','Cart.session_id','Cart.order_details','product_delivery_pin_code','delivery_address_id','billing_address_id','couponid','coupon_discount_amount']);

            return response()->json(['status'=>'success', 'unid'=>base64_encode($uorderID) ]);

        } else {

            return response()->json(['status'=>'failed' ]);
        }
    }

    public function paySuccess(Request $request){
        //print_r($request);
        $ouid = request('order_unique_id');

        if($ouid != ''){
            $unique_id = base64_decode($ouid);

            $checkUniqueOrder = Order::where(['unique_order_id' => $unique_id])->first();

            if($checkUniqueOrder){

                $getOrder = Order::where(['unique_order_id' => $unique_id, 'payment_status' => 'C', 'order_status' => 'OP', 'type' => 'order'])->first();

                if($getOrder){
                    return view('site.checkout.thank_you', ['order_unique_id' => $unique_id, 'orderAmt' => $getOrder->final_ordered_amount, 'request' => $request]);
                }else{
                    abort('404');
                    die();
                }
            }else{
                abort('404');
                die();
            }

        }else{
            abort('404');
            die();
        }
    }
       

    public function payFailed(Request $request){
        $ouid = request('order_unique_id');
        
        if( $ouid != null ){
            $unique_order_id    = isset($ouid)?$ouid:'';

            if($unique_order_id != ''){

                $getOrder = Order::where(['unique_order_id' => $unique_id, 'payment_status' => 'P', 'order_status' => 'IP', 'type' => 'cart'])->first();

                if($getOrder){
                    $order = Order::where([
                                        'unique_order_id' => $unique_order_id,
                                        'user_id'         => Auth::user()->id,
                                        'type'            => 'cart'
                                    ])->first();
                    if( $order != null ){
                        Order::where(['id' => $order->id])
                                    ->update([
                                        'payment_status'=> 'P',
                                        'order_status'  => 'CL',
                                        'type'          => 'cancel',
                                    ]);

                        OrderDetail::where(['order_id' => $order->id])->update(['order_status' => 'CL']);
                    } 

                    Session::forget(['Cart.order_id','Cart.session_id','Cart.order_details','product_delivery_pin_code','delivery_address_id','billing_address_id','couponid','coupon_discount_amount']);   
                }  

            }            
        }
        return view('site.checkout.payment_error');
    }

    // public function paySuccess(Request $request){
    //     $ouid = request('order_unique_id');
        
    //     //dd($ouid);
    //     if($ouid != ''){
    //         $unique_id = base64_decode($ouid);

    //         $checkUniqueOrder = Order::where(['unique_order_id' => $unique_id]);

    //         if($checkUniqueOrder){

    //             $getOrder = Order::where(['unique_order_id' => $unique_id, 'payment_status' => 'P', 'order_status' => 'IP', 'type' => 'cart'])->first();

    //             if($getOrder){
    //                 //echo "yes"; die;
    //                 $order_id = $getOrder->id;

    //                 $appliedDtl = AppliedCoupon::where('order_id', $order_id)->first();
    //                 if( $appliedDtl != null ){
    //                     $couponDtl = Coupon::where('id', $appliedDtl->coupon_id)->first();
    //                     if($couponDtl->promotion == 'Y'){
    //                         Promotional::where([
    //                             'email'  => Auth::user()->email,
    //                             'coupon_code' => $couponDtl->id
    //                         ])
    //                         ->update(['is_used' => 'Y']);
    //                     }
    //                 }

    //                 $order = Order::where([
    //                             'id'      => $order_id,
    //                             'user_id' => Auth::user()->id,
    //                             'type'    => 'cart'
    //                         ]);
    //                 $order->update([
    //                                 'payment_method'=> '2',
    //                                 'payment_status'=> 'C',
    //                                 'order_status'  => 'OP',
    //                                 'type'          => 'order',
    //                             ]);

    //                 OrderDetail::where(['order_id'  => $order_id])->update(['order_status' => 'OP']);

    //                 $order_data = Order::find($order_id);
    //                 $order_unique_id = $order_data->unique_order_id;

    //                 $user_array = Auth::user();

    //                 $order_data_1 = $this->order_dtl($order_data->id);

    //                 /*Send email to user */
    //                 $main_order_data = Order::where(['id'=>$order_data->id])->first();
    //                 //dd($main_order_data->order_message);
    //                 Mail::to(Auth::user()->email)->queue(new EmailPlaceOrder($user_array,$order_data_1,$main_order_data));

    //                 //Order send BCC Lists
    //                 //$bccemails = ['auto-update@giftbasketworldwide.com'];
    //                // Mail::bcc($bccemails)->queue(new EmailPlaceOrder($user_array,$order_data_1,$main_order_data));

    //                 Session::forget(['Cart.order_id','Cart.session_id','Cart.order_details','product_delivery_pin_code','delivery_address_id','billing_address_id','couponid','coupon_discount_amount']);

    //                 return view('site.checkout.thank_you', ['order_unique_id' => $unique_id]);

    //             }else{
                    
    //                 $checkAlreadyOrder = Order::where(['unique_order_id' => $unique_id, 'payment_status' => 'C', 'order_status' => 'OP', 'type' => 'order'])->first();
    //                 if($checkAlreadyOrder){
    //                     return view('site.checkout.thank_you', ['order_unique_id' => $unique_id]);
    //                 }else{
    //                     abort('404');
    //                     die();
    //                 }
    //             }

    //         }else{
    //             abort('404');
    //             die();
    //         }


    //     }else{
    //         abort('404');
    //         die();
    //     }
        
    // }
}