import cjs from "./sass.node.js";

export const compile = cjs.compile;
export const compileAsync = cjs.compileAsync;
export const compileString = cjs.compileString;
export const compileStringAsync = cjs.compileStringAsync;
export const Logger = cjs.Logger;
export const SassArgumentList = cjs.SassArgumentList;
export const SassBoolean = cjs.SassBoolean;
export const SassColor = cjs.SassColor;
export const SassFunction = cjs.SassFunction;
export const SassList = cjs.SassList;
export const SassMap = cjs.SassMap;
export const SassNumber = cjs.SassNumber;
export const SassString = cjs.SassString;
export const Value = cjs.Value;
export const CustomFunction = cjs.CustomFunction;
export const ListSeparator = cjs.ListSeparator;
export const sassFalse = cjs.sassFalse;
export const sassNull = cjs.sassNull;
export const sassTrue = cjs.sassTrue;
export const Exception = cjs.Exception;
export const PromiseOr = cjs.PromiseOr;
export const info = cjs.info;
export const render = cjs.render;
export const renderSync = cjs.renderSync;
export const TRUE = cjs.TRUE;
export const FALSE = cjs.FALSE;
export const NULL = cjs.NULL;
export const types = cjs.types;

let printedDefaultExportDeprecation = false;
function defaultExportDeprecation() {
  if (printedDefaultExportDeprecation) return;
  printedDefaultExportDeprecation = true;
  console.error(
      "`import sass from 'sass'` is deprecated.\n" +
      "Please use `import * as sass from 'sass'` instead.");
}

export default {
  get compile() {
    defaultExportDeprecation();
    return _cliPkgExports.compile;
  },
  get compileAsync() {
    defaultExportDeprecation();
    return _cliPkgExports.compileAsync;
  },
  get compileString() {
    defaultExportDeprecation();
    return _cliPkgExports.compileString;
  },
  get compileStringAsync() {
    defaultExportDeprecation();
    return _cliPkgExports.compileStringAsync;
  },
  get Logger() {
    defaultExportDeprecation();
    return _cliPkgExports.Logger;
  },
  get SassArgumentList() {
    defaultExportDeprecation();
    return _cliPkgExports.SassArgumentList;
  },
  get SassBoolean() {
    defaultExportDeprecation();
    return _cliPkgExports.SassBoolean;
  },
  get SassColor() {
    defaultExportDeprecation();
    return _cliPkgExports.SassColor;
  },
  get SassFunction() {
    defaultExportDeprecation();
    return _cliPkgExports.SassFunction;
  },
  get SassList() {
    defaultExportDeprecation();
    return _cliPkgExports.SassList;
  },
  get SassMap() {
    defaultExportDeprecation();
    return _cliPkgExports.SassMap;
  },
  get SassNumber() {
    defaultExportDeprecation();
    return _cliPkgExports.SassNumber;
  },
  get SassString() {
    defaultExportDeprecation();
    return _cliPkgExports.SassString;
  },
  get Value() {
    defaultExportDeprecation();
    return _cliPkgExports.Value;
  },
  get CustomFunction() {
    defaultExportDeprecation();
    return _cliPkgExports.CustomFunction;
  },
  get ListSeparator() {
    defaultExportDeprecation();
    return _cliPkgExports.ListSeparator;
  },
  get sassFalse() {
    defaultExportDeprecation();
    return _cliPkgExports.sassFalse;
  },
  get sassNull() {
    defaultExportDeprecation();
    return _cliPkgExports.sassNull;
  },
  get sassTrue() {
    defaultExportDeprecation();
    return _cliPkgExports.sassTrue;
  },
  get Exception() {
    defaultExportDeprecation();
    return _cliPkgExports.Exception;
  },
  get PromiseOr() {
    defaultExportDeprecation();
    return _cliPkgExports.PromiseOr;
  },
  get info() {
    defaultExportDeprecation();
    return _cliPkgExports.info;
  },
  get render() {
    defaultExportDeprecation();
    return _cliPkgExports.render;
  },
  get renderSync() {
    defaultExportDeprecation();
    return _cliPkgExports.renderSync;
  },
  get TRUE() {
    defaultExportDeprecation();
    return _cliPkgExports.TRUE;
  },
  get FALSE() {
    defaultExportDeprecation();
    return _cliPkgExports.FALSE;
  },
  get NULL() {
    defaultExportDeprecation();
    return _cliPkgExports.NULL;
  },
  get types() {
    defaultExportDeprecation();
    return _cliPkgExports.types;
  },
};
