<?php
$total_shipping_price = 0;
$currency = App\Http\Helper::get_currency();
if( !empty( $ordersummary ) ) {
?>


    <div class="review-order-body">

        <?php
        foreach ( $ordersummary['item_dtl'] as $data ) {
            $total_shipping_price = $total_shipping_price + $data['ship_price'];
        ?>

        <div class="cart-table-details">
            <div class="cart-prd-img">
                @if(isset($data['image']) && $data['image'] != null )
                   @if(file_exists(public_path('/uploaded/product/'.$data['image'])))
                       {!! '<img src="' . URL::to('/') . '/uploaded/product/' . $data['image'] . '" >' !!}
                   @else
                       {!! '<img src="' . URL::to('/').config('global.no_image') . '" >' !!}
                   @endif
                @else
                   {!! '<img src="'.URL::to('/').config('global.no_image').'" >' !!}
                @endif
            </div>
            <div class="cart-prd-txt">
                <p class="review-order-ptitle">
                    {{ $data['product_name'] }} <br>
                   @php
                        if( $data['attribute_name'] != '' ) {
                           echo '('.$data['attribute_name'].')';
                        }
                   @endphp
                </p>
                <p class="review-order-price">
                    @php echo Currency::default($data['total_price'], ['need_currency'=>true, 'number_format'=>config('global.number_format_limit') ]); @endphp
                </p>
                <p class="review-order-quantity">Quantity : <span>{{ $data['qty'] }}</span></p>
                {{-- <p class="review-order-del-mode">
                    @php
                        if( $data['ship_price'] != 0 ) {
                            echo Currency::default($data['ship_price'], ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
                        }
                        else {
                            echo "FREE";
                        }
                    @endphp
                </p> --}}
            </div>
        </div>

        <?php
          }
        ?>


        
    </div>

    @php
        $final_price = 0;
        $final_price = $ordersummary['total_cart_price'];
    @endphp

    <?php
    $discount_amount = 0;
    $coupondata = App\Http\Helper::get_coupon_details( $ordersummary['order_id'] );
    if( $coupondata != null ) {
    ?>
    
    <?php
        if( $coupondata != null ) {
            if( $coupondata->applied_for == 'WC' ) {   //If coupon related to whole Cart
                if( $coupondata->coupon_detail->type == 'F' ) {
                    $discount_amount = number_format($coupondata->coupon_detail->amount, 2);;
                }else {
                    $discount_amount = number_format((( $ordersummary['total_cart_price'] * $coupondata->coupon_detail->amount ) / 100), 2);
                }
            }
            else{   //If coupon related to Occasion only
                $total_related_products_price = 0;
                $total_related_products_price = App\Http\Helper::get_selected_occasion_related_coupon_details($coupondata->coupon_id);
                
                if( $total_related_products_price > 0 ) {
                    if( $coupondata->coupon_detail->type == 'F' ) {
                        $discount_amount = $total_related_products_price - $coupondata->coupon_detail->amount;
                    }else {                                                
                        $discount_amount = ( $total_related_products_price * $coupondata->coupon_detail->amount ) / 100;
                    }
                }
            }
            
            //Setting coupon discount amount in session
            Session::put('coupon_discount_amount',$discount_amount);
        }
    ?>
        
    <?php
        }
    ?>

    <p class="review-order-total">
        GRAND TOTAL :
        @php
            $final_price = $ordersummary['total_cart_price'] - $discount_amount + $total_shipping_price;
            echo Currency::default($final_price, ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
        @endphp
    </p>

<?php } else { ?>

    <h3 class="fs-subtitle" style="color: red;">There are no products found in your cart.</h3>
    <a href="{{ url('/') }}" class="btns button-blue" >Continue Shopping</a>

<?php } ?>




