@php
$currency = App\Http\Helper::get_currency();
@endphp


@extends('layouts.site.app', ['title' => $home_bottom_content->meta_title, 'meta_keyword' => $home_bottom_content->meta_keyword, 'meta_description' => $home_bottom_content->meta_description])

@section('content')

    <!------- BANNER --------->
    <section class="banner">
        <a href="#">
            <img src="{{ asset('images/COF-top-banner-homepage-new.webp') }}" alt="Flowers Delivery in Chennai | Flowers to Chennai" width="1920" height="469">
        </a>
    </section>

    <!------- Flower Delivery in Chennai --------->
    <section class="flower-delivery-cat">
        <div class="fl-del-cat-titles">
            <h1>Flower Delivery in Chennai</h1>
            <p>Free Delivery in 2 hrs | #1 Chennai Florist</p>
        </div>
        <div class="fl-del-cat-body flex">
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-sameday-delivery.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>SAME DAY DELIVERY</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-Cake.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>CAKES</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-Fresh-Flower.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>FRESH FLOWERS</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-Birthday.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>BIRTHDAY</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-Anniversay.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>ANNIVERSARY</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-90min-delivery.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>90 MINS DELIVERY</p>
                </div>
            </a>
            <a href="#" class="fl-del-cat-box">
                <div class="fl-del-cat-image">
                    <img src="{{ asset('images/COF-gift-hamper.webp') }}" alt="" width="188" height="188">
                    <div class="fl-del-cat-overlay"></div>
                </div>
                <div class="fl-del-cat-txt">
                    <p>GIFT HAMPERS</p>
                </div>
            </a>
        </div>
    </section>

    <!------- Category - Top selling flowers --------->

    @if( count($featured_category) > 0 )
        @php $t = 1; $position = 1; @endphp
        @foreach($featured_category as $category)
        @php
            //echo $category->category_id;
            $product_list = App\Http\Helper::getHomepageProductsByCatId( $category->category_id, $category->data_limit);
            //dd($product_list);
        @endphp

        @if( count($product_list['product']) > 0 )
            <section class="index-category">
                <div class="index-cat-titles">
                    @if( $t == 1 )
                        <h1>{{ $category->title }}</h1>
                    @else
                        <h2>{{ $category->title }}</h2>
                    @endif
                    <p>{{ $category->description }}</p>
                </div>
                <div class="index-products clearfix">
                    @foreach( $product_list['product'] as $product )
                        @php
                            $reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
                            $earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);

                            if($product->has_attribute == 'Y'){
                                $prodPrice = App\Http\Helper::get_group_price( $product->id );
                                $mainPrice = $prodPrice->price;
                                $mrp = $prodPrice->actual_price;
                            }else{
                                $mainPrice = $product->price;
                                $mrp = $product->actual_price;
                            }
                            //echo $mainPrice;
                        @endphp
                        <div class="ind-prds-item" id="prod{{$product->id}}-{{$product->fnid}}">
                            <div class="inner-prd-item">
                                <a href="{{ url('/'.$product->slug) }}" alt="{{ $product->alt_key }}" target="_blank" aria-label="{{ $product->alt_key }}" class="img-link">
                                    
                                    @if( $product->default_product_image != null )
                                        @if(file_exists(public_path('/uploaded/product/'.$product->default_product_image['name'])))
                                            <img src="{{ asset('uploaded/product/'.$product->default_product_image['name'])}}" data-src="{{ asset('uploaded/product/'.$product->default_product_image['name'])}}" data-srcset="{{ asset('uploaded/product/thumb/'.$product->default_product_image['thumb'])}} 768w, {{ asset('uploaded/product/'.$product->default_product_image['name'])}} 1200w, {{ asset('uploaded/product/'.$product->default_product_image['name'])}} 1500w, {{ asset('uploaded/product/'.$product->default_product_image['name'])}} 1900w" class="lazy" alt="{{$product->alt_key}}" title="{{$product->alt_key}}" width="500" height="500">
                                        @else
                                            {!! '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >' !!}
                                        @endif
                                    @else
                                        {!! '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >' !!}
                                    @endif

                                </a>
                                <div class="inner-prd-texts">
                                    <p class="prd-det-title">
                                        @if(strlen($product->product_name) > 100)
                                            {{ substr($product->product_name, 0, 99) }}..
                                        @else
                                            {{ $product->product_name }}
                                        @endif
                                    </p>
                                    <div class="prd-price-box">
                                        <div class="price-tag">
                                            <p class="main-price-section" id="price-tag-usd">
                                                {!! Currency::default($product->price, ['need_currency' => true, 'number_format' => config('global.number_format_limit')]) !!}
                                            </p>
                                            @if($mrp > $mainPrice)
                                            <p class="off-price-section" id="price-tag-usd">
                                                {!! Currency::default($mrp, ['need_currency' => true, 'number_format' => config('global.number_format_limit')]) !!}
                                            </p>
                                            @endif
                                            @if($mrp > 0 && ($mrp > $mainPrice))
                                                @php $discount = (($mrp - $mainPrice)/$mrp) * 100; @endphp
                                                @if(number_format($discount, 2) > 0)
                                                    <p class="price-sec-off">{{number_format($discount, 0)}}% Off</p>
                                                @endif
                                            @endif
                                        </div>
                                        <div class="ind-prd-cart-nd-star">
                                            @if($reviewRating['rating'] > 0 )
                                            <div class="ratings">
                                                <div class="rating-yellow">
                                                    @php
                                                        $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                                                    @endphp
                                                    @for($k=1; $k<=5; $k++)
                                                        @if( $avgRating >= $k)
                                                            <span class="gold"> &#9733;</span>
                                                        @else
                                                            <span class="gray"> &#9733;</span>
                                                        @endif
                                                    @endfor
                                                </div>
                                                <div class="rating-count">( 345 )</div>
                                            </div>
                                            @endif
                                            <a href="{{ url('/'.$product->slug) }}" class="ind-cart-btn">Add to Cart</a>
                                            <p class="earl-delv">Earliest Delivery : <span class="ear-del">{{  $earliestDelivery }}</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </section>
        @endif

        @if( $t == 1 )    

            <!------- Top Gifts By Occasion --------->
            <section class="top-gifts-cat">
                <!-- <canvas class="snow" id="snow"></canvas> -->
                <div class="top-gifts-titles">
                    <h2>Top Gifts By Occasion</h2>
                    <p>Perfect gifts for every occasion | #1 Chennai Florist</p>
                </div>
                <div class="top-gifts-body flex ">
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-1.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>BIRTHDAY</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-2.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>WEDDING</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-3.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>ANNIVERSARY</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-4.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>GET WELL SOON</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-5.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>CONGRATULATIONS</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-6.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>CELEBRATIONS DAY</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-7.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>FESTIVALS</p>
                        </div>
                    </a>
                    <a href="#" class="top-gifts-box">
                        <div class="top-gifts-image">
                            <img src="{{ asset('images/occ-8.webp') }}" alt="" width="600" height="600">
                            <div class="top-gifts-overlay"></div>
                        </div>
                        <div class="top-gifts-txt">
                            <p>CONDOLENCE</p>
                        </div>
                    </a>
                </div>
            </section>

        @elseif( $t == 2 )

        <!------- Category - Express Delivery Gifts --------->
        <!-- <section class="index-category">
            <div class="index-cat-titles">
                <h2>Express Delivery Gifts</h2>
                <p>Free Delivery in 2 hrs | #1 Chennai Florist</p>
            </div>
            <div class="index-products clearfix">
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Lovely Seasonal Florals Bunch
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Lovely Seasonal Florals Bunch
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Lovely Seasonal Florals Bunch
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Lovely Seasonal Florals Bunch
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="ind-prds-item">
                    <div class="inner-prd-item">
                        <a href="#" aria-label="" target="_blank" class="img-link">
                            <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                                srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                        </a>
                        <div class="inner-prd-texts">
                            <p class="prd-det-title">
                                Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                    <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                    <p class="price-sec-off">17% Off</p>
                                </div>
                                <div class="ind-prd-cart-nd-star">
                                    <div class="ratings">
                                        <div class="rating-yellow">
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gold"> &#9733;</span>
                                            <span class="gray"> &#9733;</span>
                                        </div>
                                        <div class="rating-count">( 345 )</div>
                                    </div>
                                    <a href="#" class="ind-cart-btn">Add to Cart</a>
                                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> -->
        
            <!------- Popular Searches Gifts By Relation --------->
            <section class="popular-searches-cat">
                <!-- <canvas class="snow" id="snow"></canvas> -->
                <div class="ppl-sr-cat-titles">
                    <h2>Popular Searches Gifts By Relation</h2>
                    <p>Gifts special to your loved ones | #1 Chennai Florist</p>
                </div>
                <div class="category-wrapper">
                    <div class="owl-carousel owl-theme ppl-sr-cat-body flex">
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-1.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Boyfriend</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-2.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Girlfriend</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-3.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Husband</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-4.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Wife</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-5.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Him</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-6.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Her</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-7.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Kids</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-8.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Father</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-9.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Mother</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-10.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Parents</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-11.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Fiance</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-12.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>GrandMother</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-13.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>GrandFather</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-14.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Brother</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-15.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Sister</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-16.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Boss</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-17.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Colleague</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-18.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Daughter</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-19.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>Son</p>
                            </div>
                        </a>
                        <a href="#" class="item ppl-sr-cat-box">
                            <div class="ppl-sr-cat-image">
                                <img src="{{ asset('images/rel-20.webp') }}" alt="" width="600" height="600">
                                <div class="ppl-sr-cat-overlay"></div>
                            </div>
                            <div class="ppl-sr-cat-txt">
                                <p>GrandParents</p>
                            </div>
                        </a>
                    </div>
                </div>
            </section>

        @endif
        
        @php $t++; @endphp
        @endforeach
    @endif    

    <!------- Category - New Arrival Bouquets & Arrangements --------->
    <!-- <section class="index-category">
        <div class="index-cat-titles">
            <h2>New Arrival Bouquets & Arrangements</h2>
            <p>Fresh & Fabulous newest arrivals | #1 Chennai Florist</p>
        </div>
        <div class="index-products clearfix">
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Lovely Seasonal Florals Bunch
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Lovely Seasonal Florals Bunch
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Lovely Seasonal Florals Bunch
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/Lovely Seasonal Florals Bunch 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Lovely Seasonal Florals Bunch
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ind-prds-item">
                <div class="inner-prd-item">
                    <a href="#" aria-label="" target="_blank" class="img-link">
                        <img fetchpriority="High" src="{{ asset('images/DELIGHTFUL RED ROSES 1.webp') }}"
                            srcset="" imagesizes="" width="500" height="500" alt="" loading="lazy">
                    </a>
                    <div class="inner-prd-texts">
                        <p class="prd-det-title">
                            Delightful Red Roses Bouquet with Red Velvet Cake N Teddy
                        </p>
                        <div class="prd-price-box">
                            <div class="price-tag">
                                <p class="main-price-section" id="price-tag-usd">&#8377; 1,215</p>
                                <p class="off-price-section" id="price-tag-usd">&#8377; 1,645</p>
                                <p class="price-sec-off">17% Off</p>
                            </div>
                            <div class="ind-prd-cart-nd-star">
                                <div class="ratings">
                                    <div class="rating-yellow">
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gold"> &#9733;</span>
                                        <span class="gray"> &#9733;</span>
                                    </div>
                                    <div class="rating-count">( 345 )</div>
                                </div>
                                <a href="#" class="ind-cart-btn">Add to Cart</a>
                                <p class="earl-delv">Earliest Delivery : <span class="ear-del">Tomorrow</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> -->

    <!------- Top Searched Occasion in Chennai --------->
    <section class="top-search-oc">
        <div class="top-search-oc-titles">
            <h2>Top Searched Occasion in Chennai</h2>
            <p>Find the Perfect Gift | #1 Chennai Florist</p>
        </div>
        <div class="top-search-oc-body flex">
            <a href="#" class="top-search-oc-box">
                <div class="top-search-oc-image">
                    <img src="{{ asset('images/occ-rect-1.webp') }}" alt="" width="357" height="496">
                    <div class="top-search-oc-overlay"></div>
                    <div class="top-search-oc-border"></div>
                    <p class="top-search-see-more">See More</p>
                </div>
                <div class="top-search-oc-txt">
                    <p>Send Birthday Gifts to Chennai</p>
                </div>
            </a>
            <a href="#" class="top-search-oc-box">
                <div class="top-search-oc-image">
                    <img src="{{ asset('images/occ-rect-2.webp') }}" alt="" width="357" height="496">
                    <div class="top-search-oc-overlay"></div>
                    <div class="top-search-oc-border"></div>
                    <p class="top-search-see-more">See More</p>
                </div>
                <div class="top-search-oc-txt">
                    <p>Online Anniversary Gifts To Chennai</p>
                </div>
            </a>
            <a href="#" class="top-search-oc-box">
                <div class="top-search-oc-image">
                    <img src="{{ asset('images/occ-rect-3.webp') }}" alt="" width="357" height="496">
                    <div class="top-search-oc-overlay"></div>
                    <div class="top-search-oc-border"></div>
                    <p class="top-search-see-more">See More</p>
                </div>
                <div class="top-search-oc-txt">
                    <p>Rakhi To Chennai</p>
                </div>
            </a>
            <a href="#" class="top-search-oc-box">
                <div class="top-search-oc-image">
                    <img src="{{ asset('images/occ-rect-4.webp') }}" alt="" width="357" height="496">
                    <div class="top-search-oc-overlay"></div>
                    <div class="top-search-oc-border"></div>
                    <p class="top-search-see-more">See More</p>
                </div>
                <div class="top-search-oc-txt">
                    <p>Valentine's Gifts To Chennai</p>
                </div>
            </a>
            <a href="#" class="top-search-oc-box">
                <div class="top-search-oc-image">
                    <img src="{{ asset('images/occ-rect-5.webp') }}" alt="" width="357" height="496">
                    <div class="top-search-oc-overlay"></div>
                    <div class="top-search-oc-border"></div>
                    <p class="top-search-see-more">See More</p>
                </div>
                <div class="top-search-oc-txt">
                    <p>Mother's Day Gifts Express Delivery</p>
                </div>
            </a>
        </div>
    </section>

    <!------- About Us --------->
    <section class="about-us">
        <div class="about-us-title">
            <h2>About Us</h2>
        </div>
        <div class="about-us-body flex">
            <div class="about-us-txt">
                <p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>
            </div>
            <div class="about-us-img">
                <img src="{{ asset('images/ABOUT-US-IMAGE.webp') }}" alt="" width="464" height="474">
            </div>
        </div>
    </section>

    <!------- Deliver Location --------->
    <section class="index-delevery-loc">
        <div class="index-delevery-loc-title">
            <div class="idl-title-upper">
                <h1>We Deliver</h1>
                <div class="deliver-options">
                    <p>Flowers</p>
                    <p>Cakes</p>
                    <p>Chocolates</p>
                    <p>Sweets</p>
                    <p>Gifts</p>
                </div>
            </div>
            <div class="idl-title-lower">
                <p>Speedy Delivery at Your Doorstep | #1 Chennai Florist</p>
            </div>
        </div>
        <div class="index-delevery-loc-body">
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/coimbatore.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Coimbatore</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/thiruchirapally.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Thiruchirapally</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/pondicherry.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Pondicherry</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/mettupalayam.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Mettupalayam</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/tirunelveli.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Tirunelveli</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/karaikal.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Karaikal</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/mahabalipuram.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Mahabalipuram</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/madras.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Madras</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/tuticorin.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Tuticorin</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/salem.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Salem</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/namakkal.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Namakkal</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/chidambaram.webp') }}" alt="">
                </div>
                <div class="index-loc-name">
                    <p>Chidambaram</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/karur.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Karur</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/mamallapuram.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Mamallapuram</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/madurai.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Madurai</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/tirupur.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Tirupur</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/kanyakumari.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Kanyakumari</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/sivakasi.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Sivakasi</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/kanchipuram.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Kanchipuram</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/trichy.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Trichy</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/otacmund.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Otacmund</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/ooty.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Ooty</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/vellore.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Vellore</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/coonoor.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Coonoor</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/thanjavur.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Thanjavur</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/kotagiri.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Kotagiri</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/rameshwaram.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Rameshwaram</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <div class="index-loc-img">
                    <img src="{{ asset('images/tiruchirapally.webp') }}" alt="" width="35" height="37">
                </div>
                <div class="index-loc-name">
                    <p>Tiruchirapally</p>
                </div>
            </a>
            <a href="#" class="index-loc">
                <p>More Locations...</p>
            </a>
        </div>
    </section>

    <!------- Testimonials --------->
    <section class="testimonials">
        <div class="testimonials-title">
            <h2>Testimonials</h2>
            <p># Clients' Feedback</p>
        </div>
        <div class="testimonials-body flex">
            <div class="owl-carousel owl-theme testimonials-right">
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-1.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"Your delicious Sweets, luxurious gift hamper and spectacular flowers have enlivened their celebration in Chennai in a grand way. I will always use you to send gifts to Chennai. Thank you."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Priyanshu, New York, USA</p>
                    </div>
                </div>
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-2.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"Your Timely Delivery have made a great impact on my sister-in-law. Thanks for quick flower delivery in Chennai."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Jisnu, Australia</p>
                    </div>
                </div>
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-3.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"Thank you very much for the superb Birthday Cake. My friend is delighted with the fabulous fresh cake. I will definitely recommending your website to my associates for sending cakes to Chennai."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Rakesh, Singapore</p>
                    </div>
                </div>
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-4.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"Thanks a lot. Your flowers were awesome. My granny was thrilled to get it on her birthday. I will love to shop from your website in future again."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Pragya, Bangkok, Thailand</p>
                    </div>
                </div>
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-5.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"Thanks for the timely delivery of kids gifts to Chennai to my sister. You did a great job. My sister was really very happy with the quality of gifts."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Sashikala, UK</p>
                    </div>
                </div>
                
                <div class="item">
                    <div class="testimonials-texts">
                        <div class="testimonials-texts-img">
                            <img src="{{ asset('images/testimonial-img-6.webp') }}" alt="" width="118" height="117">
                        </div>
                        <p class="testimonials-review">"My daughter loved the wonderful basket of flowers. Thank you for your extra effort with regards to the delivery of my online order of flowers to Chennai."</p>
                        <div class="testimonials-ratings">
                            <div class="rating-yellow">
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gold"> &#9733;</span>
                            <span class="gray"> &#9733;</span>
                            </div>
                        </div>
                        <p class="testimonials-name">- Vishnu, USA</p>
                    </div>
                </div>
            </div>
            <div class="testimonials-left">
                <img src="{{ asset('images/IMAGE-FOR-TESTIMONIALS.webp') }}" alt="" width="564" height="458">
            </div>
        </div>
    </section>
    
    <!------- Blog Reads --------->
    <section class="index-blog">
        <div class="top-search-oc-titles index-blog-titles">
            <h2>Blog Reads</h2>
            <p>Check out our Latest Blog Reads | #1 Chennai Florist</p>
        </div>
        <div class="index-blog-body flex">
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-1.webp') }}" alt="" width="600" height="600">
                    <div class=" index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Apt Protection Of Flowers</p>
                </div>
            </a>
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-2.webp') }}" alt="" width="600" height="600">
                    <div class="index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Make Blossoms Your Messengers in Chennai</p>
                </div>
            </a>
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-3.webp') }}" alt="" width="600" height="600">
                    <div class="index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Dress Up Your Domestics By Flowers in Chennai</p>
                </div>
            </a>
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-4.webp') }}" alt="" width="600" height="600">
                    <div class="index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Intensify Occasions Through Blossoms in Chennai</p>
                </div>
            </a>
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-5.webp') }}" alt="" width="600" height="600">
                    <div class="index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Developing and Sustaining A Flower Garden</p>
                </div>
            </a>
            <a href="#" class="index-blog-box">
                <div class="index-blog-image">
                    <img src="{{ asset('images/blogs-6.webp') }}" alt="" width="600" height="600">
                    <div class="index-blog-overlay"></div>
                    <div class="index-blog-border"></div>
                    <p class="index-blog-see-more">See More</p>
                </div>
                <div class="index-blog-txt">
                    <p>Enrich Your Learning About Blossoms</p>
                </div>
            </a>
        </div>
    </section>

    <!------- Newsletter --------->
    <section class="newsletter flex">
        <div class="newsletter-left">
            <img src="{{ asset('images/Frame 198.webp') }}" alt="" width="964" height="500">
        </div>
        <div class="newsletter-right flex">
            <div class="newsletter-right-upper flex">
                <div class="discount-txt">
                    <p class="disc-txt-1">Sign Up With Your Email</p>
                    <p class="disc-txt-2">Get A Discount Coupon of</p>
                </div>
                <div class="discount-img">
                    <img src="{{ asset('images/discount.webp') }}" alt="" width="230" height="194">
                </div>
            </div>
            <div class="newsletter-right-lower">
                <form action="">
                    <div class="newsletter-email flex">
                        <input type="email" placeholder="Enter your Email Address">
                        <button>Subscribe</button>
                    </div>
                    <input type="checkbox" id="updated" name="updated" value="Bike">
                    <label for="updated" class="updated-label">Stay Updated !</label>
                </form>

            </div>
        </div>
    </section>

    <!------- Need Assistance --------->
    <section class="index-assistance">
        <div class="index-assistance-title">
            <h2>Need Assistance</h2>
            <p>Available 24/7 for all your needs | #1 Chennai Florist</p>
        </div>
        <div class="index-assistance-body flex">
            <div class="index-assistance-img">
                <img src="{{ asset('images/need-assistance.webp') }}" alt="" width="2000" height="1613">
                <!-- <img src="{{ asset('images/need-assistance-crop.webp') }}" alt=""> -->
            </div>
            <div class="index-assistance-txt">
                <h3>Contact Information</h3>
                <div class="index-assistance-box">
                    <p class="ind-assist-title">Chennai Online Florist</p>
                    <p>New Avadi Road, Alagappa Nagar, Kilipauk Chennai, Tamil Nadu 600010</p>
                    <p><strong>India - +91 8100771984</strong></p>
                </div>
                <div class="index-assistance-box">
                    <p class="ind-assist-title">Inbound Calling Timing</p>
                    <p>Mon-Fri - <strong>9:30 AM - 7 PM</strong></p>
                    <p>Sat, Sun and All Holidays - <strong>9:30 AM - 3:30 PM</strong></p>
                    <div class="ind-assist-social-icon">
                        <img src="{{ asset('images/logos_whatsapp-icon.webp') }}" alt="" width="30" height="30">
                        <img src="{{ asset('images/logos_google-gmail.webp') }}" alt="" width="30" height="24">
                        <img src="{{ asset('images/messenger 1.webp') }}" alt="" width="30" height="30">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!------- How did it go (Help section) --------->
    <section class="help-section">
        <div class="boy-img">
            <img src="{{ asset('images/boy.webp') }}" alt="" width="221" height="133">
        </div>
        <div class="help-body flex">
            <div class="help-txt">
                <p>How did it go?</p>
                <p>Were you able to find what you needed?</p>
            </div>
            <div class="help-option-buttons flex">
                <button class="need-help-btn">NEED MORE HELP ?</button>
                <button class="yes-btn">YES</button>
            </div>
        </div>
    </section>

    <!------- Yellow bar specialities --------->
    <section class="specialities flex">
        <div class="specialities-box">
            <div class="specialities-img">
                <img src="{{ asset('images/FLORIST.webp') }}" alt="">
            </div>
            <div class="specialities-txt">
                <p>Local Florist Shop</p>
            </div>
        </div>
        <div class="specialities-box">
            <div class="specialities-img">
                <img src="{{ asset('images/solar_delivery-bold.webp') }}" alt="">
            </div>
            <div class="specialities-txt">
                <p>Free Delivery</p>
            </div>
        </div>
        <div class="specialities-box">
            <div class="specialities-img">
                <img src="{{ asset('images/mdi_shop-location.webp') }}" alt="">
            </div>
            <div class="specialities-txt">
                <p>Same Day Delivery</p>
            </div>
        </div>
        <div class="specialities-box">
            <div class="specialities-img">
                <img src="{{ asset('images/icon-park-outline_flash-payment.webp') }}" alt="">
            </div>
            <div class="specialities-txt">
                <p>Secure Payment</p>
            </div>
        </div>
        <div class="specialities-box">
            <div class="specialities-img">
                <img src="{{ asset('images/healthicons_contact-support.webp') }}" alt="">
            </div>
            <div class="specialities-txt">
                <p>Customer Support</p>
            </div>
        </div>
    </section>

    <!------- Bottom content --------->
    <section class="content">
        <div class="content-wrapper show-more-height">
            <h2>Send Flowers to Chennai :</h2>
            <p>Express your feelings of love or emotion by choosing to Gift Flowers in Chennai. Order Online to Send Beautiful Bouquet for your family and friends in Chennai on special celebrations and occasions like Valentine's Day, Mother's Day, Christmas, Rakhi. Sending the perfect Flowers to your loved ones in Chennai has become a matter of few clicks with www.ChennaiOnlineFlorists.com at your service for assured delivery in the city and all around Tamil Nadu.</p>
            <h2>Same Day Flower Delivery in Chennai by Local Florist :</h2>
            <p>Get Assured Same Day Delivery of Flower Bouquets and Floral Arrangements in Chennai. You can also order for Fresh Baked Cakes and Gifts from our website for a quick delivery by our Local Florist in Chennai today. Add Balloons, Chocolates, Teddy, Greeting Cards and many more presents with your order for Flower Gifts to be delivered today. No Extra Charge for Sending Same Day Flowers and Gifts anywhere in Chennai.</p>
            <h2>Send Online Flowers to Chennai at Mid-Night on Birthdays, Anniversary and other Occasions :</h2>
            <p>Depth of relationships are best expressed when Birthday and Anniversary special wishes are conveyed to people at the stroke of the Mid Night hour. You can rely on our service for an assured Mid-Night Delivery of Flowers in Chennai. Send Online Flowers to Chennai for guaranteed 12 o'clock delivery of Floral Gifts on all days and every occasions.</p>
            <h2>Flower Delivery in Chennai, Tamil Nadu - Same Day Delivery to surprise your loved ones:</h2>
            <p>With online shopping, ordering Flowers on the same day has become much simpler and worry-free. Order Online for Flower Delivery in Chennai on the Same Day and ensure that your friends and family in the city feel happy when they receive Flowers on festivals like Onam, Rakhi, Diwali, Christmas, New Year etc. Make your choice from our huge selection of Fresh Flowers bouquet like classic Red Rose Bouquet, Pink Carnations Basket or colorful Anthurium N Orchids with White Daisies in a Vase, all ready for assured delivery at Chennai at low cost. Our expert Local Florist takes care about freshness and quality while designing them in various designs and patterns. With Online Flowers Gift feel free to show admiration for your loved ones residing in any location like Besant Nagar, Ramapuram, Mannur, T Nagar etc in the city. We provide Free Shipping for all Floral Gifts at Chennai and all over Tamil Nadu.</p>
            <h2>Flower Delivery On Birthday and Anniversary by Local Florist in Chennai:</h2>
            <p>Be it Anniversary, Birthday, Wedding, Valentine's Day, Mother's Day or any other celebration, fascinating Bouquet of Fresh Flowers guarantees sweet smile on your dear one's face. Visit our online store and choose from plenty of Flower and Gift available at the lowest price and in varied designs. Book your Order now and get Same Day Flowers & Gifts Delivery in Chennai Online. From Fresh Flower Bouquet to Cakes, Chocolate, Fresh Fruit Basket, Teddy, Greetings Card and your personalized message, we can deliver all of them in just 3 to 4 hours to all over Chennai and Tamil Nadu. Our Assured Delivery service caters to deliver fresh and best quality of Floral Gifts to your doorstep without any shipping charges. We also do Mid Night Flower Delivery at Chennai.</p>
            <h2>How to Deliver Flowers in Chennai to celebrate special occasions - Free Shipping all over Tamil Nadu:</h2>
            <p>Make any event or occasion special and memorable with Delivery of Flowers in Chennai. Be it simple and stunning Mixed Carnations Bouquet or vibrant Oriental Lilies Basket or blooming Orchids in a designer Vase or Red Roses in Heart Shape Arrangement, every Online Floral Gift designed by our expert Local Florist in Chennai clearly convey your heartfelt wishes for your special one. Send a Gift of Flowers with alluring Chocolate Bookey, Mylar Balloons, Fresh Fruits Basket, Dry Fruits Tray, Teddy Bear or Greeting card on various occasions like Valentine's Day, Mother's Day, Deepawali, Raksha Bandhan etc in Chennai to celebrate the festivity in style. We also give Same-day and Mid-night Delivery service for sending the finest quality Flowers to every nook-n-corner like Shanthi Nagar, Anna Nagar, Padiyanallur, Madambakkam, Perungudi etc in Chennai, Tamil Nadu.</p>
            <p>Celebrate Rakhi 2024 on 19th August . Now order & Send Rakhi to Chennai. Through us you can also Send Rakhi Gifts to Canada & other countries worldwide. Get assured Delivery of Rakhi Gifts in UK. Choose and place your order for Sweets, Raksha Bandhan Gifts, Pooja Thali, Chocolates, Designer Lumba & Premium Rakhi Online for your brother residing at any corner of the world and get guaranteed Delivery of good quality, low priced Rakhi Gifts in USA & all over the world.</p>
            <h2>Receive Best Online Flowers in Chennai - Same Day Free Delivery</h2>
            <p>Isn't it a great idea to gift pretty and choicest flowers on a special occasion? Of course yes! So if you are looking for a superb online Flower Delivery in Chennai, then you are at the right place! We provide Online Flower Delivery service on the same day and in least possible time at your doorstep. Being a reputed local florist, we make sure that you love what we deliver! Therefore, we choose flowers personally for our prestigious customers. We gladly flaunt our special features like same day delivery of your selected floral gifts, mid-night delivery to send birthday and anniversary surprises, express free shipping service and much more. We make sure that you never miss a chance to send fresh flowers, along with warm wishes for your loved ones. So what are you waiting for? Choose your favourite floral bunch today from our huge collection and send it to your family and friends in Chennai, Tamil Nadu.</p>
            <h2>Why we are the #1 Florist in Chennai - Unique Gifts Online, Flower Delivery in 2 Hrs, Free Shipping from Multiple Local Shops</h2>
            <p>Flowers are the most beautiful thing present in nature. Flowers make nature colorful and attractive. Flowers and humans have a very long relationship which is ever since we exist. The flower is present in all of our occasions and they play a very important role, and definitely, flowers are the most beautiful gift God has gifted to our planet. And taking it forward, we too get unique gifts of flowers online free delivery in Chennai in just 2 hours from Multiple Local Florists Shops in town for gifting to each other on occasions and events and on every festival. That's why we known as the #1 Florist in Chennai.</p>
            <p>To help you send flowers in Chennai in the easiest steps now, you can go online on our website and choose from the various options that we have and send it to your family and friends. Some flowers type that we have include Roses, Carnations, Tulips, Lily, Gladiolus, Tube Rose, Orchids etc. We have flowers and bouquet delivery for Valentine's Day, birthday, anniversary, mother's day, wedding, father's day etc and that too in very cheap rates. You can find a lot of different types of bouquets occasion based on our website like for mother's day you can send pink carnations bouquet, heart shape Dutch Roses for Valentine's Day, 100 Red N Yellow Roses tall basket arrangement for wedding, orchids n lilies bouquet for father's day etc. You can also curate them as per your will. We have unique designs of bouquets, single Rose posy and also multiple flower arrangements just for your mom, dad, wife, husband, fiancee etc. You can also gift your beloved with combos like Plants with Bouquet, Chocolate and Flower, Teddy with Flowers in Vase, Cakes with Flowers etc. These are some of the most popular ones on our website. We bring you amazing flowers from Local Flower Shops hand crafted by Expert Florist to make bouquet with love just for you. We also have Heart Shaped Red Rose Arrangements, fresh flower bouquets of different kind of flowers mixed and matched and even with single type of flower. The flowers that we send to you are freshly picked and much taken care of, then brought to you which lights up every event and festival in your home. Get flower delivery from us and make your friends and families smile.</p>
            <p>We understand that buying things online can be a little intimidating for some people given about the quality and sincerity of the product especially when it comes to sending gifts to another city like Chennai. But you can be assured that on our website you'll find everything genuine one hundred percent. Our customers are our top priority and we leave no space in attaining that trust. Through our Express Delivery services beautiful bouquets will get delivered at your loved one's doorstep with Free Delivery and we also have 24/7 customer assistance just for you. We also have Mid Night Delivery for you as well where you can send flowers and other gift items to Chennai at twelve am on birthdays or anniversaries or any other event of need.</p>
            <h2>Fresh Flowers for Birthday to Chennai - Mid Night Delivery</h2>
            <p>Flowers are the most beautiful gesture present in nature. Flowers make nature colorful and attractive. Flowers and humans have a very long relationship which is ever since we exist. Flower can be gifted for all our occasions and they play a very important role, and definitely, flowers are the most beautiful gift God has bestowed on our planet earth. And taking it forward, we too use flowers for Sending to each other on occasions or events like birthdays. Giving flowers on birthdays can be one of the best presents that you can buy online.</p>
            <p>We bring to you Fresh Flowers that you can send to your beloved friends and family members and make them smile. We have a lot of flowers and bouquets that you can send on birthdays to Chennai. We have flowers and bouquets for Girlfriend, Mother, Wife and others. We have a range of flowers such as Lilies, carnations, daisies, orchids, Gladiolus, Rajnigandha sticks and a lot more in variety. Along with that, our online Florist Shop offers a range of predesigned bouquets that you can send to your loved person on their birthday living in Chennai like, Lily Bouquet, carnations basket, orchids bunch, gerberas in vase etc. We also have bouquets of different types of flower arrangements, mix and match which will leave you in awe. You can also order chocolates, teddy, sweets, dry fruits with Personalized Flowers at their doorstep in Chennai. We deliver to you the best flowers from the local Florist Shop who can craft flowers in different shapes n sizes and it is one of the freshest you'll ever find. Flowers are something that makes everyone happy, just keeping them at home and the mood is uplifted of every person who sees them and inhales their fragrance. We offer full customization on the presents and the flowers. Along with flowers, you can send them other items that go with flowers like cakes or ice creams as well. Send Online Cakes with Flowers Today to Chennai to your beloved family or friend's home and surprise them on their birthday. Also, you can attach a Birthday greetings card along with your flowers and bouquets with your message written in it. We bring to you Same Day Flowers Free Shipping where you can send flowers on the same day of placing the order on our website. Get Same Day Flowers with Ice Cream as well, it will surely make your loved one smile. Along with that, we also bring to you shipping at midnight where you can send flowers at Mid Night to your dear ones home.</p>
            <p>We understand that buying things online can be a little intimidating for some people given about the quality and sincerity of the product especially when it comes to sending flowers to another city like Chennai. But you can be assured that on our website you'll find everything genuine one hundred percent. Our customers are our top priority and we leave no space in attaining that trust. Through our Express Free Shipping services beautiful floral bouquet will get delivered at your loved one's doorstep on their birthdays. We have 24/7 customer assistance, live tracking and order modification just for you.</p>
            <h2>Flowers are evergreen. Send Flower Bouquet at low price as Gifts to Chennai from USA with free shipping for all celebrations:</h2>
            <div class="content-table">
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Events</p>
                    </div>
                    <div class="content-table-right">
                        <p>- Fast Moving Gifts</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Wedding Celebrations</p>
                    </div>
                    <div class="content-table-right">
                        <p>- Aromatic Affection Gerbera Assemblage, 24 Mixed Roses with Assorted Cadburys Chocolate, Fresh Fruits Basket with Tasty Haldiram Soan papdi and Rose Bouquet</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Birth-Day</p>
                    </div>
                    <div class="content-table-right">
                        <p>- Delicious Chocolate Assortment Hamper Basket, Chocolate Flavor Eggless Cake, Small Teddy, Assorted Cadburys Chocolate and 12 Red Roses Bouquet</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Marriage Anniversary</p>
                    </div>
                    <div class="content-table-right">
                        <p>- Joyful Hearty Arrangement of Thirty Mixed Roses, small Teddy, Assorted Cadburys Chocolate and 12 Red Roses Bouquet, Confectionery Bliss 1 Kg Eggless Fresh Fruit Cake</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Friendship's Day</p>
                    </div>
                    <div class="content-table-right">
                        <p>- 1 Kg Black Forest Cake with 5 Balloons, Energetic Gift Basket of Food and Grocery, Laughing Buddha</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Father's Day</p>
                    </div>
                    <div class="content-table-right">
                        <p>- 12 Red Roses Bouquet and Kaju Katli 250 Gms, Nivea Gift Hamper for Men, Silver Plated mandap (size: 2.5 inch) with Golden plated Ganesh Laxmi Idol</p>
                    </div>
                </div>
                <div class="content-table-row">
                    <div class="content-table-left">
                        <p>Rakhi</p>
                    </div>
                    <div class="content-table-right">
                        <p>- Signature Chocolate Basket Hamper, Haldiram Rosogolla 1 Kg, Delicous Chocolate Bars Hamper</p>
                    </div>
                </div>
            </div>
        </div>
        <button class="show-more">Show More</button>
    </section>

    <!------- Services --------->
    <section class="index-services flex">
        <div class="index-services-box">
            <div class="ind-serv-icon">
                <img src="{{ asset('images/secure-payments.webp') }}" alt="">
            </div>
            <div class="ind-serv-title">
                <p>100% Secure Payments</p>
            </div>
            <div class="ind-serv-txt">
                <p>We respect your Privacy. payment is through Secure Payment gateway, www.ccavenue.com/ Securepg.Fssnet.co.in which is secured. This means that your online transactions are absolutely safe, secure and confidential.</p>
            </div>
        </div>
        <div class="index-services-box">
            <div class="ind-serv-icon">
                <img src="{{ asset('images/customer-service.webp') }}" alt="">
            </div>
            <div class="ind-serv-title">
                <p>Customer Service</p>
            </div>
            <div class="ind-serv-txt">
                <p>We value your experience, so we are at your service 24x7. Same day and mid night delivery are done by our local florists. We also deliver on holidays and sunday.</p>
            </div>
        </div>
        <div class="index-services-box">
            <div class="ind-serv-icon">
                <img src="{{ asset('images/payment-options.webp') }}" alt="">
            </div>
            <div class="ind-serv-title">
                <p>Payment Options</p>
            </div>
            <div class="ind-serv-txt">
                <p>We are accepting all major credit and debit cards.</p>
            </div>
            <div class="ind-serv-cards">
                <div class="ind-serv-cards-row">
                    <img src="{{ asset('images/card1.webp') }}" alt="">
                    <img src="{{ asset('images/card2.webp') }}" alt="">
                    <img src="{{ asset('images/card3.webp') }}" alt="">
                    <img src="{{ asset('images/card4.webp') }}" alt="">
                    <img src="{{ asset('images/card5.webp') }}" alt="">
                    <img src="{{ asset('images/card6.webp') }}" alt="">
                </div>
                <div class="ind-serv-cards-row">
                    <img src="{{ asset('images/card7.webp') }}" alt="">
                    <img src="{{ asset('images/card8.webp') }}" alt="">
                    <img src="{{ asset('images/card9.webp') }}" alt="">
                </div>
            </div>
        </div>
    </section>

    <!------- Local Florist Shops --------->
    <section class="local-florist-shops">
        <div class="local-florist-shops-title">
            <h2>Local Florist Shops</h2>
            <p>Free Delivery in 2 hrs | #1 Chennai Florist</p>
        </div>
        <div class="local-florist-shops-body flex">
            <div class="loc-flor-shops-left">
                <section class="tag-box-con">
                    <div class="tag-flx">
                        <div class="tags drs__light_flash_effect">
                            <p>IN TAMIL NADU</p>
                            <div class="tri"> </div>
                            <div class="tag-con"> </div>
                            <div class="shining"> </div>
                            <div class="shining-2"> </div>
                        </div>
                   </div>
                </section>
                <div class="loc-flor-shops-locations flex">
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">61, BUSSY STREET</p>
                            <p>Opp. Saraswathi Mahal</p>
                            <p class="lfsd-zip">Pondicherry - 605001</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">109/8, OLD BUS STAND</p>
                            <p class="lfsd-zip">Tuticorin-628002</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">ANNAI SATHYA NAGAR</p>
                            <p>Vellaithottam,</p>
                            <p class="lfsd-zip">Coimbatore-641006</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">TANK STREET</p>
                            <p>K.K Nagar, Thorapadi</p>
                            <p class="lfsd-zip">Vellore-632001</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">CLASSIC TOWR</p>
                            <p>10th Cross, Thillai Nagar</p>
                            <p class="lfsd-zip">Trichy-620015</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">GOKHALE LANE</p>
                            <p>Madurai Race Course</p>
                            <p class="lfsd-zip">Madurai-625002</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">PALAYAMKOTTAI</p>
                            <p class="lfsd-zip">Tirunelveli-627002</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">CSR BUILDING</p>
                            <p>Opp to SRC Hospital Brough Road</p>
                            <p class="lfsd-zip">Erode-638001</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">B.K.V BUILDINGS, DR. JAGANATHA NAGAR</p>
                            <p>Avinash Riad</p>
                            <p class="lfsd-zip">Coimbatore-641014</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">MADHURA PLAZA, ALAGAPURAM</p>
                            <p>7A - AVK Maruthu Plaza</p>
                            <p class="lfsd-zip">Salem-636004</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="loc-flor-shops-right">
                <section class="tag-box-con">
                    <div class="tag-flx">
                        <div class="tags drs__light_flash_effect">
                            <p> IN CHENNAI </p>
                            <div class="tri"> </div>
                            <div class="tag-con"> </div>
                            <div class="shining"> </div>
                            <div class="shining-2"> </div>
                        </div>
                   </div>
                </section>
                <div class="loc-flor-shops-locations flex">
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">VIJAY TOWER</p>
                            <p>18, Halls Road Kilpauk</p>
                            <p class="lfsd-zip">Chennai-600010</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">B9,ALSA ARCADE</p>
                            <p>2nd Avenue, Anna Nagar East</p>
                            <p class="lfsd-zip">Chennai-600102</p>
                        </div>
                    </div>
                    <div class="loc-flor-shops-details">
                        <div class="lfsd-left">
                            <i class="fa fa-map-marker" aria-hidden="true"></i>
                        </div>
                        <div class="lfsd-right">
                            <p class="lfsd-bold">43B, NEW AVADI ROAD,</p>
                            <p>2nd Avenue, Anna Nagar East</p>
                            <p class="lfsd-zip">Chennai-600102</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection