@foreach ( $products as $product )
@php 
$currency = App\Http\Helper::get_currency();
$earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);
$reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
@endphp

<div class="ind-prds-item" id="{{ $product->id }}">
    <div class="inner-prd-item IT{{$product->id}}-{{$product->fnid}}">
        <?php
            if($product->has_attribute == 'Y'){
                $prodPrice = App\Http\Helper::get_group_price( $product->id );
                $mainPrice = $prodPrice->price;
                $mrp = $prodPrice->actual_price;
            }else{
                $mainPrice = $product->price;
                $mrp = $product->actual_price;
            }
            //echo $mainPrice;
        ?>
        <a href="{{ url($product->slug) }}" aria-label="" target="_blank" class="img-link">
            
            @php
                $productDefaultImg = App\Http\Helper::getdefaultProductImage( $product->id );
            @endphp
            @if(isset($productDefaultImg) && $productDefaultImg['name'] != null)
                @if(file_exists(public_path('/uploaded/product/'.$productDefaultImg['name'])))
                    <img src="{{ asset('uploaded/product/'.$productDefaultImg['name'])}}" data-src="{{ asset('uploaded/product/'.$productDefaultImg['name'])}}" data-srcset="{{ asset('uploaded/product/thumb/'.$productDefaultImg['thumb'])}} 768w, {{ asset('uploaded/product/'.$productDefaultImg['name'])}} 1200w, {{ asset('uploaded/product/'.$productDefaultImg['name'])}} 1500w, {{ asset('uploaded/product/'.$productDefaultImg['name'])}} 1900w" class="lazy" alt="{{$product->alt_key}}" title="{{$product->alt_key}}" width="500" height="500">
                @else
                    {!! '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >' !!}
                @endif
            @else
                {!! '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >' !!}
            @endif
        </a>
        <div class="inner-prd-texts">
            <p class="prd-det-title">
                @if(strlen($product->product_name) > 100)
                    {{ substr($product->product_name, 0, 99) }}..
                @else
                    {{ $product->product_name }}
                @endif
            </p>
            <div class="prd-price-box">
                <div class="price-tag">
                    <p class="main-price-section" id="price-tag-usd">
                        {!! Currency::default($product->price, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]) !!}
                    </p>
                    @if($mrp > $mainPrice)
                        <p class="off-price-section" id="price-tag-usd">{!! Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]) !!}</p>
                    @endif
                    @if($mrp > 0 && ($mrp > $mainPrice))
                        @php $discount = (($mrp - $mainPrice)/$mrp) * 100; @endphp
                        @if(number_format($discount, 2) > 0)
                            <p class="price-sec-off">{{number_format($discount, 0)}}% Off</p>
                        @endif
                    @endif
                </div>
                <div class="ind-prd-cart-nd-star">
                    
                    <div class="ratings">
                        @if($reviewRating['rating'] > 0 )
                        <div class="rating-yellow">
                            @php
                                $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                            @endphp
                            @for($k=1; $k<=5; $k++)
                                @if( $avgRating >= $k)
                                    <span class="gold"> &#9733;</span>
                                @else
                                    <span class="gray"> &#9733;</span>
                                @endif
                            @endfor
                        </div>
                        <div class="rating-count">( {{$reviewRating['review']}} )</div>
                        @endif
                    </div>
                    
                    <a href="{{ url($product->slug) }}" class="ind-cart-btn">Add to Cart</a>
                    <p class="earl-delv">Earliest Delivery : <span class="ear-del">{{  $earliestDelivery }}</span></p>
                </div>
            </div>
        </div>

    </div>
</div>

@endforeach