<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php 
$currency = App\Http\Helper::get_currency();
$earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);
$reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
?>

<div class="ind-prds-item" id="<?php echo e($product->id); ?>">
    <div class="inner-prd-item IT<?php echo e($product->id); ?>-<?php echo e($product->fnid); ?>">
        <?php
            if($product->has_attribute == 'Y'){
                $prodPrice = App\Http\Helper::get_group_price( $product->id );
                $mainPrice = $prodPrice->price;
                $mrp = $prodPrice->actual_price;
            }else{
                $mainPrice = $product->price;
                $mrp = $product->actual_price;
            }
            //echo $mainPrice;
        ?>
        <a href="<?php echo e(url($product->slug)); ?>" aria-label="" target="_blank" class="img-link">
            
            <?php
                $productDefaultImg = App\Http\Helper::getdefaultProductImage( $product->id );
            ?>
            <?php if(isset($productDefaultImg) && $productDefaultImg['name'] != null): ?>
                <?php if(file_exists(public_path('/uploaded/product/'.$productDefaultImg['name']))): ?>
                    <img src="<?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?>" data-src="<?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?>" data-srcset="<?php echo e(asset('uploaded/product/thumb/'.$productDefaultImg['thumb'])); ?> 768w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1200w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1500w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1900w" class="lazy" alt="<?php echo e($product->alt_key); ?>" title="<?php echo e($product->alt_key); ?>" width="500" height="500">
                <?php else: ?>
                    <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >'; ?>

                <?php endif; ?>
            <?php else: ?>
                <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >'; ?>

            <?php endif; ?>
        </a>
        <div class="inner-prd-texts">
            <p class="prd-det-title">
                <?php if(strlen($product->product_name) > 100): ?>
                    <?php echo e(substr($product->product_name, 0, 99)); ?>..
                <?php else: ?>
                    <?php echo e($product->product_name); ?>

                <?php endif; ?>
            </p>
            <div class="prd-price-box">
                <div class="price-tag">
                    <p class="main-price-section" id="price-tag-usd">
                        <?php echo Currency::default($product->price, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?>

                    </p>
                    <?php if($mrp > $mainPrice): ?>
                        <p class="off-price-section" id="price-tag-usd"><?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?></p>
                    <?php endif; ?>
                    <?php if($mrp > 0 && ($mrp > $mainPrice)): ?>
                        <?php $discount = (($mrp - $mainPrice)/$mrp) * 100; ?>
                        <?php if(number_format($discount, 2) > 0): ?>
                            <p class="price-sec-off"><?php echo e(number_format($discount, 0)); ?>% Off</p>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="ind-prd-cart-nd-star">
                    
                    <div class="ratings">
                        <?php if($reviewRating['rating'] > 0 ): ?>
                        <div class="rating-yellow">
                            <?php
                                $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                            ?>
                            <?php for($k=1; $k<=5; $k++): ?>
                                <?php if( $avgRating >= $k): ?>
                                    <span class="gold"> &#9733;</span>
                                <?php else: ?>
                                    <span class="gray"> &#9733;</span>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        <div class="rating-count">( <?php echo e($reviewRating['review']); ?> )</div>
                        <?php endif; ?>
                    </div>
                    
                    <a href="<?php echo e(url($product->slug)); ?>" class="ind-cart-btn">Add to Cart</a>
                    <p class="earl-delv">Earliest Delivery : <span class="ear-del"><?php echo e($earliestDelivery); ?></span></p>
                </div>
            </div>
        </div>

    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH /home/rightflorist/public_html/giftbasketsbrazil.rightflorist.org/resources/views/site/product/loadmore.blade.php ENDPATH**/ ?>