<?php
//dd($product_details);
$meta_data['keyword'] = strip_tags($product_details->meta_keyword);
$meta_data['description'] = $product_details->meta_description;
$meta_title = $product_details->meta_title;

//dd($request);
//echo Request::server('HTTP_REFERER');
//print_r(array_slice(explode('/', Request::server('HTTP_REFERER')), -1, 1));


?>
<?php 
$currency = App\Http\Helper::get_currency(); 
$earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product_details->delivery_delay_days, $product_details->id);

$getUploadedPersonilizedImg = App\Http\Helper::get_sessionwise_uploadimg($request, $product_details->id); 
?>
<?php $meta = App\Http\Helper::get_meta($meta_data, $data); ?>
<?php $deliveryDelayDays = App\Http\Helper::getDeliveryDelayDays($product_details->delivery_delay_days); ?>

<?php 

    $getTimeCalc = App\Http\Helper::get_timecalc($product_details->id); 
    //dd($getTimeCalc);

?>



<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.js"></script>

<!------- BREADCRUMB --------->
<section class="product-breadcrumb">
    <ul>
        <li><a href="<?php echo e(url('/')); ?>">HOME</a></li>
        <?php
            $lastCat = array_slice(explode('/', Request::server('HTTP_REFERER')), -1, 1);
            //dd(strpos($lastCat[0], '?query='));
            $checkUrl = App\Http\Helper::checkBreadcrumbUrl($lastCat[0]);
        ?>

        <?php if($lastCat[0] != ''): ?>
                
            <?php if($checkUrl == 1): ?>

            <?php else: ?>
                <?php if(str_contains($lastCat[0], '?query=')): ?>

                <?php else: ?>
                <li><a href="<?php echo e(url('/'.$lastCat[0])); ?>"><?php echo e(strtoupper(str_replace("-"," ",$lastCat[0]))); ?></a></li>
                <?php endif; ?>
            <?php endif; ?>    
        <?php endif; ?>

        <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$breadcrumb_text): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
            <?php //echo $key; 
                //echo $breadcrumb[1];
                if($key == 0){
                    $url_breadcrumb = '/'.$breadcrumb[0];
                }elseif($key == 1){
                    $checkFUrl = App\Http\Helper::checkFalseUrl($breadcrumb[1]);
                    if($checkFUrl == 1){
                        $url_breadcrumb = '/'.$breadcrumb[1];
                    }else{
                        $url_breadcrumb = '/'.$breadcrumb[0].'/'.$breadcrumb[1];
                    }
                    //$url_breadcrumb = '/'.$breadcrumb[0].'/'.$breadcrumb[1];
                }
            ?>

            <?php if(end($breadcrumb) == $breadcrumb_text): ?>
                <li><?php echo e(strtoupper(str_replace('-', ' ', $breadcrumb_text))); ?></li>
            <?php else: ?>
                <li><a href="<?php echo e(url('/').$url_breadcrumb); ?>"><?php echo e(strtoupper(str_replace('-', ' ', $breadcrumb_text))); ?></a></li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</section>


<!------- PRODUCT DETAILS --------->
<section class="main-container">
    <div id="image-section">
        <div>
            <?php
                $getImages = App\Http\Helper::get_productimages($product_details->id); 
                $img = $thumbimg = 1;
            ?>
            <?php if($getImages): ?>
                <?php $__currentLoopData = $getImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prodimg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="image-container" id="image-<?php echo e($img); ?>" <?php if($prodimg->default_image == 'Y'){ ?>style="display: block;" <?php } else { ?> style="display: none;" <?php } ?> >
                        <img src="<?php echo e(URL::to('/') . '/uploaded/product/'. $prodimg->name); ?>" alt="<?php echo e($product_details->alt_key); ?>" style="width:500px">
                    </div>
                    <?php $img++; ?> 
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="image-container" style="display: block;">
                    <img src="<?php echo e(URL::to('/').config('global.no_image')); ?>" alt="<?php echo e($product_details->alt_key); ?>">
                </div>
            <?php endif; ?>
        </div>
        <?php if($getImages): ?>
            <div class="thumbnail-container">
                <?php $__currentLoopData = $getImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prodthumbimg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="thumblink <?php if($prodthumbimg->default_image == 'Y'){ ?>selected<?php } ?>" onclick="openImage(event,'image-<?php echo e($thumbimg); ?>')">
                        <img src="<?php echo e(URL::to('/') . '/uploaded/product/'. $prodthumbimg->name); ?>" alt="<?php echo e($product_details->alt_key); ?>">
                    </div>
                    <?php $thumbimg++; ?> 
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>

    <div id="text-section">
        <div class="sub-container-1">
            <div class="product-name-container">
                <div class="prod-name"><?php echo $product_details->product_name; ?></div>
                <?php if(count($productRating) > 0): ?>
                    <?php
                        $totalRating = $avgRating = 0;
                        foreach($productRating as $rate){
                            $totalRating = $totalRating + $rate->rating;
                        }
                        $avgRating = round($totalRating / count($productRating), 0 );
                        //echo $avgRating; die;
                    ?>
                    <div class="prod-ratings">
                        <div class="prod-rating-yellow">
                            <?php for($k=1; $k<=5; $k++): ?>
                                <?php if( $avgRating >= $k): ?>
                                    <span class="gold"> ★</span>
                                <?php else: ?>
                                    <span class="gray"> ★</span>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        <div class="prod-rating-count"><?php echo e(count($productRating)); ?> Reviews </div>
                        
                    </div>
                <?php else: ?>
                    <div class="no-rvw">
                        <div><p>No reviews added? be the first reviewer?</p></div>
                        <div><a href="javascript:void(0)" id="add-review" class="add-review-button">Click Here</a></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php if( $product_details->has_attribute == 'N' ): ?>
            <div class="prod-price-container">
                <div class="prod-price"><?php echo Currency::default($product_details->price, ['need_currency' => true, 'number_format' => config('global.number_format_limit')]); ?></div>
                <div class="prod-discount">
                    <p class="prod-off">7% Off</p>
                    <p class="prod-discount-price">&#8377; 1890</p>
                </div>
            </div>
        <?php endif; ?>

        <?php $product_attr_id = 0; ?>
        <?php if( $product_details->has_attribute == 'Y' ): ?>
            <div class="variant-container" style="margin-top:35px">
                <div class="swiper" id="carousel1">
                    <div class="swiper-wrapper">
                        <?php
                            if ( $product_details->product_attribute != null ){
                                $d=1;
                                foreach ( $product_details->product_attribute as $attribute ) {
                        ?>
                        <div class="swiper-slide">
                            <div>
                                <div>
                                    <input type="radio" name="optradio" class="var-card pro_attr" id="card-<?php echo e($d); ?>"  data-attrid="<?php echo e($attribute->id); ?>" <?php if($d==1)echo 'checked="checked"'; ?> autocomplete="off">
                                    <label for="card-<?php echo e($d); ?>">
                                        <div class="card">
                                            <span class="check_btn">
                                                <i class="fa fa-check-circle fa-lg" aria-hidden="true"></i>
                                            </span>
                                            <div class="title"><?php echo $attribute->title; ?></div>
                                            <div class="var-price-container">
                                                <div class="price-cont">
                                                    <div class="price">
                                                        <?php echo Currency::default($attribute->price, ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]); ?>

                                                    </div>
                                                    <?php if($attribute->actual_price > $attribute->price): ?>
                                                    <div class="old-price">
                                                        <?php echo Currency::default($attribute->actual_price, ['need_currency' => true, 'number_format' => config('global.number_format_limit')]); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if($attribute->actual_price > 0 && ($attribute->actual_price > $attribute->price)): ?>
                                                    <?php $attdiscount = (($attribute->actual_price - $attribute->price)/$attribute->actual_price) * 100; ?>
                                                    <?php if(number_format($attdiscount, 2) > 0): ?>
                                                        <div class="discount"><?php echo e(number_format($attdiscount, 0)); ?>% Off</div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </label>
                                    <?php if($d==1){ 
                                        $product_attr_id = $attribute->id;
                                    } ?>
                                </div>
                            </div>
                        </div>
                        <?php
                            $has_options = true;
                                $d++;
                                }
                            }
                        ?>
                    </div>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                </div>
            </div>
        <?php endif; ?>
        

        <div class="pin-outer-cont">

            <div class="quantity-main">
                <p class="quantity-main-title">Quantity : </p>
                <div class="quantity-main-selector">
                    <button class="main-minus-btn">-</button>
                    <span class="main-quantity">1</span>
                    <button class="main-plus-btn">+</button>
                </div>
            </div>

            <div class="pincode-cont">
                <div class="pincode-form">
                    <div class="pincode-icon">
                        <i class="fa fa-map-marker fa-2x" aria-hidden="true"></i>
                    </div>
                    <div class="pincode-container">
                        <input type="text" name="pincode" id="pincode" maxlength="6" placeholder="Enter Pincode"
                            autocomplete="off" value="<?php echo e(session('pincode_session_id', '')); ?>" required>
                        <div id="pincode-error" class="error-message"></div>
                        <div id="pincode-info" class="pincode-area-show"></div>
                    </div>
                    <div class="pincode-chck-btn">
                        <button class="check-availability checkpin" onclick="validatePincode()">Check Availability</button>
                        <div class="loading-circle-pincode inactive-text"></div>
                        <span class="order-available successpin inactive-text"></span>
                    </div>
                </div>
                <span class="pincode-text non-delivery-pincode-info"></span>
            </div>
            
        </div>

        <?php if($product_details->delivery_type == 'H'): ?>

        <div class="prd-det-delivery">

            <div class="delivery-type">
                <div class="same-day-delivery-option">
                    <input type="radio" name="delivery-type-option" value="sameday" data-dtid = "<?php echo e($getTimeCalc['dtString']); ?>|<?php echo e($getTimeCalc['sdate']); ?>|within 3hrs|99" id="same-day-delivery" checked>
                    <label for="same-day-delivery">
                        <div class="s-d-delivery-txt">
                            <p><?php echo e($getTimeCalc['dtString']); ?></p>
                            <p>Delivery within <span>3 hrs</span></p>
                            <p>&#8377; 99</p>
                        </div>
                        <div class="s-d-delivery-img">
                            <img src="images/real-time-2.webp" alt="">
                        </div>
                        <div class="s-d-delivery-check">
                            <img src="<?php echo e(asset('images/green-fil-tick.webp')); ?>" alt="" class="s-delivery-check-img">
                        </div>
                    </label>
                </div>

                <div class="schedule-delivery-option">
                    <input type="radio" name="delivery-type-option" value="fromnextday" id="schedule-delivery">
                    <label for="schedule-delivery">
                        <div class="s-delivery-txt">
                            <p>Schedule Delivery</p>
                            <p>Select your prefered date and time</p>
                        </div>
                        <div class="s-delivery-img">
                            <img src="<?php echo e(asset('images/real-time-1.webp')); ?>" alt="">
                        </div>
                        <div class="s-delivery-check">
                            <img src="<?php echo e(asset('images/green-fil-tick.webp')); ?>" alt="" class="s-d-delivery-check-img">
                        </div>
                    </label>
                </div>
            </div>

            <div class="delivery-date-time">

                <div class="delivery-date">
                    <input type="text" name="date" value="" id="datepicker" placeholder="Select Delivery Date"
                        autocomplete="off" class="delivery-date">
                    <label id="delivery_date_error"  class="alert-error"></label>
                </div>

                <div class="delivery-time-type">
                    <p class="delivery-time-type-title">Select Delivery Type</p>
                    <div class="delivery-time-type-body">
                        <div class="delivery-time-type-box">
                            <input type="radio" name="delivery-time-type-option" value="standard|0" id="standard-time"
                                checked>
                            <label for="standard-time">
                                <div class="delivery-time-type-txt">
                                    <p>STANDARD TIME</p>
                                    <p>Free</p>
                                    <p>Delivery during selected slots</p>
                                </div>
                                <div class="del-time-type-check">
                                    <img src="<?php echo e(asset('images/green-fil-tick.webp')); ?>" alt="" class="standard-time-check-img">
                                </div>
                            </label>
                        </div>
                        <div class="delivery-time-type-box">
                            <input type="radio" name="delivery-time-type-option" value="fixedtime|199" id="fixed-time">
                            <label for="fixed-time">
                                <div class="delivery-time-type-txt">
                                    <p>FIXED TIME</p>
                                    <p>&#8377; 199</p>
                                    <p>Delivery during selected 2 hours slots</p>
                                </div>
                                <div class="del-time-type-check">
                                    <img src="<?php echo e(asset('images/green-fil-tick.webp')); ?>" alt="" class="fixed-time-check-img">
                                </div>
                            </label>
                        </div>
                        <div class="delivery-time-type-box">
                            <input type="radio" name="delivery-time-type-option" value="midnight|250" id="midnight">
                            <label for="midnight">
                                <div class="delivery-time-type-txt">
                                    <p>MIDNIGHT</p>
                                    <p>&#8377; 250</p>
                                    <p>Delivery between 11:00 PM - 11:59 PM</p>
                                </div>
                                <div class="del-time-type-check">
                                    <img src="<?php echo e(asset('images/green-fil-tick.webp')); ?>" alt="" class="midnight-check-img">
                                </div>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="delivery-time">

                    <p class="delivery-time-title">Select Time</p>

                    <div class="delivery-time-body inactive-text" id="standard-time-list">
                        <div class="select-time-slot">
                            <p>Select Time Slot</p>
                            <img src="<?php echo e(asset('images/green-down-arrow.webp')); ?>" alt="">
                        </div>
                        
                        <ul class="delivery-time-list standard-Time-div">
                            <!-- <li class="delivery-time-slot" data-deltime="09AM - 01PM">09AM - 01PM</li>
                            <li class="delivery-time-slot" data-deltime="01PM - 05PM">01PM - 05PM</li>
                            <li class="delivery-time-slot" data-deltime="05PM - 09PM">05PM - 09PM</li>
                            <li class="delivery-time-slot" data-deltime="09PM - 11PM">09PM - 11PM</li> -->
                        </ul>
                    </div>

                    <div class="delivery-time-body inactive-text" id="fixed-time-list">
                        <div class="select-time-slot">
                            <p>Select Time Slot</p>
                            <img src="<?php echo e(asset('images/green-down-arrow.webp')); ?>" alt="">
                        </div>
                        <ul class="delivery-time-list fixed-Time-div">
                            <!-- <li class="delivery-time-slot"  data-deltime="08AM - 10AM">08AM - 10AM</li>
                            <li class="delivery-time-slot"  data-deltime="10AM - 12PM">10AM - 12PM</li>
                            <li class="delivery-time-slot"  data-deltime="12PM - 02PM">12PM - 02PM</li>
                            <li class="delivery-time-slot"  data-deltime="02PM - 04PM">02PM - 04PM</li>
                            <li class="delivery-time-slot"  data-deltime="04PM - 06PM">04PM - 06PM</li>
                            <li class="delivery-time-slot"  data-deltime="06PM - 08PM">06PM - 08PM</li>
                            <li class="delivery-time-slot"  data-deltime="08PM - 10PM">08PM - 10PM</li>
                            <li class="delivery-time-slot"  data-deltime="09PM - 11PM">09PM - 11PM</li> -->
                        </ul>
                    </div>

                    <div class="delivery-time-body inactive-text" id="midnight-time-list">
                        <div class="select-time-slot">
                            <p>Select Time Slot</p>
                            <img src="<?php echo e(asset('images/green-down-arrow.webp')); ?>" alt="">
                        </div>
                        <ul class="delivery-time-list midnight-Time-div">
                            <!-- <li class="delivery-time-slot" data-deltime="11:00pm - 11:59pm">11:00pm - 11:59pm</li> -->
                        </ul>
                    </div>

                    <label id="delivery_time_error" class="alert-error"></label>
                </div>
            </div>
        </div>

        <?php else: ?>

        <div class="prd-det-delivery">

            <div class="delivery-type">
                <div class="schedule-delivery-option">
                    <label for="schedule-delivery">
                        <div class="s-delivery-txt">
                            <p>Standard Delivery - Free</p>
                            <p>Select your prefered date</p>
                        </div>
                        <div class="s-delivery-img">
                            <img src="<?php echo e(asset('images/real-time-1.webp')); ?>" alt="">
                        </div>
                    </label>
                </div>
            </div>

            <div class="delivery-date-time" style="display:block;">
                <div class="delivery-date">
                    <input type="text" name="date" value="" id="datepicker" placeholder="Select Delivery Date"
                        autocomplete="off" class="delivery-date">
                    <label id="delivery_date_error"  class="alert-error"></label>
                </div>
            </div>

        </div>

        <?php endif; ?>

        <section class="pdp-descInfo-container" style="position: relative;">
            <div class="pdp-descInfo-header-cont">
                <div class="pdp-descInfo-header-links tablink activeee" onclick="openProductInfo(event,'Description')">
                    <span>Description</span>
                </div>
                <div class="pdp-descInfo-header-links tablink" onclick="openProductInfo(event,'Product Info')">
                    <span>Product Info</span>
                </div>
            </div>
            <div class="pdp-desc-info-container">
                <div class="pdp-desc-cont tab-content" id="Description">
                    <span class="pdp-desc-text">
                        <div>
                            <?php if( $product_details->description != '' ): ?> 
                                <?php echo $product_details->description; ?>

                            <?php endif; ?>
                        </div>
                    </span>
                </div>
                <div class="pdp-spec-cont tab-content" id="Product Info" style="display:none">
                    <div class="pdp-desc-text">
                        <div class="prodDesc_subhead_cont2">
                            <?php if( $product_details->content != '' ): ?>
                                <?php echo $product_details->content; ?>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div id="addon-section">
            <?php if($all_extra_addons): ?>
            <div class="addon-header-outer-container">
                <div class="addon-header-container">
                    <div class="addon-head">Give it a special touch !</div>
                    <div><img src="images/GIFTBOX.webp" alt="giftbox-image"></div>
                </div>
            </div>
            <?php endif; ?>
            <div class="addon-subsections">

                <?php if($all_extra_addons): ?>
                    <div class="gourmet-header-container">
                        <div class="gourmet-head">Gourmet-Addons</div>
                    </div>
                    
                    <div class="swiper" id="carousel2">
                        <div class="swiper-wrapper">
                            <?php $xaddon = 1; ?>
                            <?php $__currentLoopData = $all_extra_addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extraAddon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="card-revamp">
                                    <div>
                                        <?php if(isset($extraAddon->default_product_image) && $extraAddon->default_product_image != null ): ?>
                                            <?php if(file_exists(public_path('/uploaded/product/'.$extraAddon->default_product_image['name']))): ?>
                                                <img src="<?php echo e(URL::to('/') . '/uploaded/product/' . $extraAddon->default_product_image['name']); ?>" alt="<?php echo e($extraAddon->alt_key); ?>" class="card-img">
                                            <?php else: ?>
                                                <?php echo '<img src="' . URL::to('/').config('global.no_image'). '" alt="'. $extraAddon->alt_key .'" >'; ?>

                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php echo '<img src="' . URL::to('/').config('global.no_image'). '" alt="'. $extraAddon->alt_key .'" >'; ?>

                                        <?php endif; ?>
                                    </div>
                                    <div class="product-info">
                                        <p id="prod-title">
                                            <?php if(strlen($extraAddon->product_name) > 20): ?>
                                                <?php echo e(substr($extraAddon->product_name, 0, 19)); ?>..
                                            <?php else: ?>
                                                <?php echo e($extraAddon->product_name); ?>

                                            <?php endif; ?>
                                        </p>
                                        <p id="prod-price">
                                            <?php echo Currency::default($extraAddon->price, ['need_currency' => true, 'number_format' => config('global.number_format_limit')]); ?>

                                        </p>
                                        <div class="prod-cart-btn-container" id="fn-sec-<?php echo e($xaddon); ?>">
                                            <button class="prod-cart-btn extra-addon-cart-btn" data-xaddon="<?php echo e($xaddon); ?>" data-xaddonpid="<?php echo e($extraAddon->id); ?>" style="display: flex;">ADD 
                                                <span><img src="images/white-plus.webp" alt="plus"></span>
                                            </button>
                                            <div class="quantity-selector" style="display: none; align-items: center;">
                                                <button class="minus-btn" onclick="changeQty(<?php echo e($extraAddon->id); ?>,'minus','outer', <?php echo e($xaddon); ?>)">-</button>
                                                <span class="quantity xaddonQty">1</span>
                                                <button class="plus-btn" onclick="changeQty(<?php echo e($extraAddon->id); ?>,'plus','outer', <?php echo e($xaddon); ?>)">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $xaddon++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    </div>
                <?php endif; ?>

                <?php if(count($productRating) > 0): ?>
                    <div class="rev-header-cont">
                        <div>Reviews</div>
                        <div><img src="images/thumbs-up.webp" alt="review-icon"></div>
                    </div>

                    <div class="add-review-button">
                        <p>Add a Review</p>
                        <img src="<?php echo e(URL::to('/') . '/images/add-review.webp'); ?>" alt="">
                    </div>

                    <div class="rev-out-container" id="customer-reviews"></div>

                    <button id="load-more-btn" data-page="2" class="load-more-reviews">Load More</button>
                    <div class="review-loading" id="review-loader" style="display:none;">Loading...</div>
                <?php endif; ?>
            </div>
        </div>



        <div class="cart-btn-container">
            <div class="btn-position">

                <div style="display: none;">
                <input type="text" name="product_id" id="product_id" value="<?php echo e(base64_encode($product_details->id)); ?>">
                <input type="text" name="quantity" id="quantity" value="1">
                <input type="text" name="product_attr_id" id="product_attr_id" autocomplete="off" value="<?php echo $product_attr_id; ?>">
                <input type="text" name="product_extra_id" id="product_extra_id" autocomplete="off" value=""><br>
                <input type="text" id="delDelayDays" value="<?php echo e($deliveryDelayDays); ?>">
                <input type="text" name="deliverytype" id="deliverytype" value="" autocomplete="off">
                <input type="text" name="deliverytime" id="deliverytime" value="" autocomplete="off">
                <input type="text" name="deliverydate" id="deliverydate" value="" autocomplete="off"><br>
                <input type="text" name="delCharge" id="delCharge">
                <input type="text" name="deliverycityname" id="deliverycityname" value="" autocomplete="off"><br>
                <input type="text" name="personalizedImg" id="personalizedImg" value="" autocomplete="off">
                <input type="text" name="NeedToUploadImg" id="NeedToUploadImg" value="<?php echo e($productPersonalize ? $productPersonalize->no_of_image : 0); ?>" autocomplete="off">
                <input type="text" name="UploadedImg" id="UploadedImg" value="0" autocomplete="off">
                </div>

                <?php if(!$productPersonalize): ?>
                    <div class="btn-container">
                        <!-- <div onclick="on()"> -->
                            <button id="add-to-cart" class="add-to-cart-revamp product_add_to_cart" >
                                <span>Add to Cart</span><i class="fa fa-shopping-cart" aria-hidden="true"></i>
                                <div class="loading-circle inactive-text" style="top:28%"></div>
                            </button>
                        <!-- </div> -->
                    </div>
                <?php else: ?>
                    <div class="">
                        <div class="personalize-btn-section">
                            <button id="personalize-btn" class="add-to-cart-revamp"><span>PERSONALIZE</span><i
                                    class="fa fa-pencil-square-o" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class="edit-and-add-btn-section" style="display: none;">
                            <button id="edit-image-btn" class="add-to-cart-revamp"><span>EDIT IMAGE</span><i
                                    class="fa fa-pencil-square-o" aria-hidden="true"></i>
                            </button>
                            <button id="add-to-cart" class="add-to-cart-revamp product_add_to_cart">
                                <span>ADD TO CART</span><i class="fa fa-shopping-cart" aria-hidden="true"></i>
                                <div class="loading-circle inactive-text" style="top:28%"></div>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php
    $similar_product_list = App\Http\Helper::getSimilarProducts($lastCat[0], $product_details->id, 10);
?>

<?php if( count($similar_product_list['product']) > 0 ): ?>
<div class="section-2">
    <div class="similar-gift-title">
        <p>Similar Gift Recommendations</p>
    </div>
    <div class="similar-gift-body">
        <div class="owl-carousel owl-theme" id="similar-gifts">
            <?php $__currentLoopData = $similar_product_list['product']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php
                    $reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
                    $earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);
                ?>
                <?php
                    if($product->has_attribute == 'Y'){
                        $prodPrice = App\Http\Helper::get_group_price( $product->id );
                        $mainPrice = $prodPrice->price;
                        $mrp = $prodPrice->actual_price;
                    }else{
                        $mainPrice = $product->price;
                        $mrp = $product->actual_price;
                    }
                    //echo $mainPrice;
                ?>
                <div class="prd-det-prds-item">
                    <div class="prd-det-inner-prd-item">
                        <a href="<?php echo e(url('/'.$product->slug)); ?>" aria-label="" target="_blank" class="img-link">
                            <?php if( $product->default_product_image != null ): ?>
                                <?php if(file_exists(public_path('/uploaded/product/'.$product->default_product_image['name']))): ?>
                                    <img src="<?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?>" data-src="<?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?>" data-srcset="<?php echo e(asset('uploaded/product/thumb/'.$product->default_product_image['thumb'])); ?> 768w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1200w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1500w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1900w" class="lazy" alt="<?php echo e($product->alt_key); ?>" title="<?php echo e($product->alt_key); ?>" width="500" height="500">
                                <?php else: ?>
                                    <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >'; ?>

                                <?php endif; ?>
                            <?php else: ?>
                                <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500" >'; ?>

                            <?php endif; ?>
                        </a>
                        <div class="prd-det-inner-prd-texts">
                            <p class="prd-det-title">
                                <?php if(strlen($product->product_name) > 100): ?>
                                    <?php echo e(substr($product->product_name, 0, 99)); ?>..
                                <?php else: ?>
                                    <?php echo e($product->product_name); ?>

                                <?php endif; ?>
                            </p>
                            <div class="prd-price-box">
                                <div class="price-tag">
                                    <p class="main-price-section" id="price-tag-usd">
                                        <?php echo Currency::default($product->price, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?>

                                    </p>
                                    <?php if($mrp > $mainPrice): ?>
                                    <p class="off-price-section" id="price-tag-usd">
                                        <?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?>

                                    </p>
                                    <?php endif; ?>
                                    
                                    <?php if($mrp > 0 && ($mrp > $mainPrice)): ?>
                                        <?php $discount = (($mrp - $mainPrice)/$mrp) * 100; ?>
                                        <?php if(number_format($discount, 2) > 0): ?>
                                            <p class="price-sec-off"><?php echo e(number_format($discount, 1)); ?>% Off</p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>

                                <div class="ind-prd-cart-nd-star">
                                    <?php if($reviewRating['rating'] > 0 ): ?>
                                        <div class="ratings">
                                            <div class="rating-yellow">
                                                <?php
                                                    $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                                                ?>
                                                <?php for($k=1; $k<=5; $k++): ?>
                                                    <?php if( $avgRating >= $k): ?>
                                                        <span class="gold"> ★</span>
                                                    <?php else: ?>
                                                        <span class="gray"> ★</span>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                            </div>
                                            <div class="rating-count">( <?php echo e($reviewRating['review']); ?> )</div>
                                        </div>
                                    <?php endif; ?>
                                    <a href="<?php echo e(url('/'.$product->slug)); ?>" class="ind-cart-btn">Add to Cart</a>

                                    <p class="earl-delv">
                                        Earliest Delivery : <span class="ear-del"><?php echo e($earliestDelivery); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php endif; ?>


<div id="addon1" onclick="off()">
    <div class="addon-content" onclick="event.stopPropagation();">

        <div class="addon-header">
            <button id="popup-close-btn">X</button>
            <p>Make It Extra Special With Below Listed Add-On </p>
        </div>

        <!-- <div id="list_gift_addons"></div> -->

        <div class="addon-body">
            <div class="modal-contentainer">

               <!--  <input type="text" name="oid" id="oid" value="">
                <input type="text" name="pid" id="pid" value="">
                <input type="text" name="giftaddonstr" id="giftaddonstr" value=""> -->

                <div id="list_gift_addons" style="min-height:500px">
                    <div class="dual-ring-loader inactive-text"></div>
                </div>

                
            </div>

        </div>

        <!-- <div class="addon-footer">
            <a class="addon-btn-back">No Thanks</a>
            <a class="addon-btn-next" id="cart-btn">Add To Cart</a>
        </div> -->
    </div>
</div>


<!-- Personalized Drop Zone -->

<div class="drop-zone-overlay"></div>
<div id="personalizeModal">
    <div class="modal-con">
        <div class="custo-header flex">
            <div class="modal-cus-hdng">
                <p><?php echo $product_details->product_name; ?></p>
            </div>
            <div class="personalize-modal-close" id="closeModalBtn">
                <img src="<?php echo e(asset('images/white-cross.webp')); ?>">
            </div>
        </div>

        <div class="drop-zone2" id="drop-zone">
            <form action="" method="post" enctype="multipart/form-data" class="dropzone" id="my-dropzone">
                
                <div class="dz-message">
                    <img src="images/cloud-green.webp">
                    <span>Drag & Drop files here <br>or<br> Browse to Upload Image</span>
                </div>
            </form>
        </div>
        
        <div id="removeDiv2" class="personalizedImageContainer">
           

            <div class="selected-image">
                <?php if(count($getUploadedPersonilizedImg) > 0): ?>
                <?php $__currentLoopData = $getUploadedPersonilizedImg; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pimg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="img-upld-div con-<?php echo e($pimg->id); ?>">
                    <div class="sub-upld-div">
                        <div>
                            <img src="<?php echo e(asset('/uploaded/personalized_image/'.$pimg->image)); ?>">
                        </div>
                    </div>
                    <div class="bin-div" id="binDiv" data-id="<?php echo e($pimg->id); ?>">
                        <p>REMOVE</p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <div class="selected-image appending-image"></div>
            </div>

            
        </div>
        
        <div class="txt-cntnt">
            <ul>
                <li>Please upload <?php echo e($productPersonalize ? $productPersonalize->no_of_image : 0); ?> Images for proceed</li>
                <li>Only Jpeg, jpg format is supported</li>
                <li>Please upload good quality images</li>
                <li>Please image size should be 300px X 300px</li>
                <li>Please ensure that you have all rights on the image.</li>
                <li>Emoticons are not allowed.</li>
            </ul>
        </div>


        <button id="save" class="save-div inactive-text">
            <div id="saveOp">
                <span>SAVE &amp; CONTINUE</span>
            </div>
        </button>

        <div class="loader1 inactive-text">
            <div class="bar1"></div>
        </div>

    </div>
</div>


<!-- Add review modal -->

<div class="add-review" id="rating_addon">
    <div class="modal-content">
        <div class="modal-heading">
            <h2>Submit Your Review</h2>
            <!-- <i class="fa-solid fa-xmark" href="javascript: void(0);" id="rating_popup_close"></i> -->
             <img src="images/white-cross.webp" alt="" id="rating_popup_close">

        </div>
        <div class="modal-body flex">
            <div class="add-review-main">
                <p class="review-success"></p>
                <form class="add-review-form">
                    <input type="hidden" id="rvpid" value="<?php echo e(base64_encode($product_details->id)); ?>" />
                    <input type="text" placeholder="Customer Name*" id="rvname" required="">
                    <label class="rtname review-error"></label>
                    <div class="add-rating flex">
                        <p>Rate this product</p>
                        <div class="rate add-rating-star">
                            <input type="radio" id="star5" name="rating" value="5" />
                            <label for="star5" title="text"></label>
                            <input type="radio" id="star4" name="rating" value="4" />
                            <label for="star4" title="text"></label>
                            <input type="radio" id="star3" name="rating" value="3" />
                            <label for="star3" title="text"></label>
                            <input type="radio" id="star2" name="rating" value="2" />
                            <label for="star2" title="text"></label>
                            <input type="radio" id="star1" name="rating" value="1" />
                            <label for="star1" title="text"></label>
                        </div>
                    </div>
                    <span class="rtstar review-error"></span>
                    <textarea placeholder="Review*" id="rvtext" rows="5"></textarea>
                    <label class="rtarea review-error"></label>
                    <input type="text" placeholder="Delivery Location*" id="rvdel_location" required="">
                    <input type="text" placeholder="From*" id="rvsender_location" required="">
                    <input type="text" placeholder="Email*" id="rvemail" required="">
                    <label class="rtemail review-error"></label>


                    <button type="submit" id="review_prod">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    .dropzone {
        width: 100%; height: 12vw;
        border: 2px dashed #60CA7E;
        border-radius: 5px;
        background-color: #F1F1F1;
        padding: 20px;
        text-align: center;
        font-family: "Lato", sans-serif;
        position: relative;
    }
    
    .dropzone .dz-message {
        margin: 0;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }
    .dropzone .dz-message img {
        max-width: 100px;
        display: block;
        margin: 0 auto 10px;
    }
    .dropzone .dz-message span {
        /*font-size: 16px;
        color: #555;*/
        text-align: center;  font-size: 16px; font-weight: 400;
    }
    .loader1 {
      width: 1500px;
      height: 5px;
      background-color: #e1e1e1;
      margin: 0 auto;
      margin-top: 10px;
      z-index: 2;
    }
    .bar1 {
      width: 0px;
      height: 5px;
      background-color: #056608;
      z-index: 1;
      animation: bar1 5s ease-out infinite;
    }
    @keyframes  bar1 {
      from {width: 0px;}
      to {width: 1500px;}
    }

    .loading-circle-pincode {
        height: 0;
        width: 0;
        padding: 13px;
        border: 5px solid #a5daa6;
        border-right-color: #15a419;
        border-radius: 22px;
        -webkit-animation: rotate 1s infinite linear;
        position: absolute;
        left: 90%;
        top: 10%;
    }

    @keyframes  rotate {
      /* 100% keyframe for  clockwise. 
         use 0% instead for anticlockwise */
      100% {
        -webkit-transform: rotate(360deg);
      }
    }

    .loading-circle {
        height: 0;
        width: 0;
        padding: 13px;
        border: 5px solid #a5daa6;
        border-right-color: #15a419;
        border-radius: 22px;
        -webkit-animation: rotate 1s infinite linear;
        position: absolute;
        left: 90%;
        top: 10%;
    }

    @keyframes  rotate {
      /* 100% keyframe for  clockwise. 
         use 0% instead for anticlockwise */
      100% {
        -webkit-transform: rotate(360deg);
      }
    }

    

    .dual-ring-loader {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #0f8213;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
        margin-top: 10%;
        margin-left: 45%;
    }

    @keyframes  spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>

<script type="text/javascript">
    
$(document).ready(function() {

    var reviewPage = 1;
    let reviewTotalRecords = 0;
    const reviewlimit = 4;
    var isLoadingReview = false;
    var productid = $("#product_id").val();
    let TotaldelayDays = Number($('#delDelayDays').val());
    

    //**** for Pincode Section ***//

        if( $('#pincode').val().length > 0 ) {
            pincodeStatus($('#pincode').val());
        }
        
        $('#pincode').on('input', function() {
            var pincode = $(this).val();
            pincodeStatus(pincode);
        });

        function pincodeStatus(pincode) {
            if (pincode.length === 6 && /^\d+$/.test(pincode)) {
                $('.checkpin').addClass('inactive-text');
                $('.loading-circle-pincode').removeClass('inactive-text');
                $.ajax({
                    url: '<?php echo e(route("pincode-check")); ?>',
                    type: 'POST',
                    data: {
                        pincode: pincode,
                        productid: productid,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        $('.loading-circle-pincode').addClass('inactive-text');
                        console.log(response);
                        if (response.valid) {
                            $('.non-delivery-pincode-info').html('')
                            if(response.deliveryStatus == 'Y'){
                                $('#pincode-error').html('');
                                $('#pincode-info').html(response.location);
                                $('.checkpin').addClass('inactive-text');
                                $('.successpin').removeClass('inactive-text');
                                $('#deliverycityname').val(response.city);
                                $('.order-available').html('Order Available <img src="images/order-tick.webp" alt="">');
                                $('.prd-det-delivery').attr('style','display: block');
                                if(response.productDelType == 'H'){
                                    $("input[name='delivery-type-option']").trigger('change');
                                }else{
                                    nonHandDeliverItem();
                                }
                            }else{
                                $('#pincode-error').html('');
                                $('#pincode-info').html(response.location);
                                $('.checkpin').addClass('inactive-text');
                                $('.successpin').removeClass('inactive-text');
                                $('#deliverycityname').val('');
                                $('.order-available').html('Error');
                                $('.non-delivery-pincode-info').html(response.message)
                            }
                        } else {
                            $('#pincode-error').html(response.message);
                            $('.prd-det-delivery').attr('style','display: none');
                        }
                    },
                    error: function() {
                        $('#pincode-error').html('Error checking pincode.');
                    }
                });
            } else if (pincode.length < 6) {
                $('#pincode-error').html(''); // Clear the result if pincode is not yet 6 digits
                $('#pincode-info').html('');
                $('.checkpin').removeClass('inactive-text');
                $('.successpin').addClass('inactive-text');
                $('.prd-det-delivery').attr('style','display: none');
            } else {
                $('#pincode-error').html('Please enter a valid 6-digit pincode.');
                $('#pincode-info').html('');
                $('.checkpin').removeClass('inactive-text');
                $('.successpin').addClass('inactive-text');
                $('.prd-det-delivery').attr('style','display: none');
            }
        }

    //**** End for Pincode Section ***//

    //**** for NonHand(Courier) Delivery Type, Date and Time Section ***//
        
        function nonHandDeliverItem() {
            $('#deliverytype').val('standard');
            $('#deliverydate').val('');
            $('#deliverytime').val('10AM to 09PM');
            $('#delCharge').val(0);
        }

    //**** End for NonHand(Courier) Delivery Type, Date and Time Section ***//

    //**** for Hand Delivery Type, Date and Time Section ***//

        $("input[name='delivery-type-option']").change(function(){
            
            if($(this).is(":checked")){
                //alert($(this).val());
                if($(this).val() == 'sameday'){
                    $(".delivery-date-time").hide(); 
                    var strExpressOptn = $(this).attr('data-dtid').split("|");
                    $('#deliverytype').val(strExpressOptn[0]);
                    $('#deliverydate').val(btoa(strExpressOptn[1]));
                    $('#deliverytime').val(strExpressOptn[2]);
                    $('#delCharge').val(strExpressOptn[3]);
                }else{
                    $(".delivery-date-time").show();
                    $('#deliverytype').val('');
                    $('#deliverydate').val('');
                    $('#deliverytime').val('');
                    $('#delCharge').val('');
                }
            }
        }); 

        $("#datepicker").datepicker({
            dateFormat: 'DD, d MM,yy',
            //beforeShowDay: DisableDates,
            minDate: addDays(calcTime('india', '+5'), TotaldelayDays),
            //minDate: 1,
            autoclose: true,
            onSelect: function(dateText, inst) {
                var date = formatDate($(this).val());
                //console.log(btoa(date));
                $("#deliverydate").val(btoa(date));
                $(".delivery-time-type").show();
                $('#delivery_date_error').html('');
                $("input[name='delivery-time-type-option']").trigger('change');
            }
        });

        function formatDate(date) {
            var d = new Date(date),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();

            if (month.length < 2) 
                month = '0' + month;
            if (day.length < 2) 
                day = '0' + day;

            return [year, month, day].join('-');
        }

        $("input[name='delivery-time-type-option']").change(function(){
            if($(this).is(":checked")){
                //alert($(this).val());

                $('#deliverytime').val('');
                var strDelTypeOptn = $(this).val().split("|");
                $('#deliverytype').val(strDelTypeOptn[0]);
                $('#delCharge').val(strDelTypeOptn[1]);
                var delType = strDelTypeOptn[0];
                $(".delivery-time").show();
                $('#delivery_time_error').html(''); 

                $.ajax({
                    url: '<?php echo e(route("deliverytimeslot")); ?>',
                    method: 'POST',
                    data: {shipId: delType, shipDate: atob($('#deliverydate').val()), _token: '<?php echo e(csrf_token()); ?>'},
                    
                    success: function(data) {
                        console.log(data);
                        $('.'+data.container_div).html(data.htmlData);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching products:', error);
                    }
                });
                
                if(strDelTypeOptn[0] == 'fixedtime'){
                    $("#standard-time-list").addClass("inactive-text");
                    $("#fixed-time-list").removeClass("inactive-text");
                    $("#midnight-time-list").addClass("inactive-text");
                }else if(strDelTypeOptn[0] == 'midnight'){
                    $("#standard-time-list").addClass("inactive-text");
                    $("#fixed-time-list").addClass("inactive-text");
                    $("#midnight-time-list").removeClass("inactive-text");
                }else{
                    $("#standard-time-list").removeClass("inactive-text");
                    $("#fixed-time-list").addClass("inactive-text");
                    $("#midnight-time-list").addClass("inactive-text");
                }

                if ($('.delivery-time-list').hasClass('toggleactive')) {
                    $(".delivery-time-list").toggle();
                    $(".delivery-time-list").removeClass('toggleactive'); 
                }else{
                   $(".select-time-slot p").html('Select Time Slot'); 
                }

                $('#deliverytime').val('');

            }
        })

        $('.select-time-slot').click(function() {
            $(".delivery-time-list").toggle(); 
            $(".delivery-time-list").addClass('toggleactive'); 
        });

        //$('.delivery-time-list li').click(function(e) {
        $(".delivery-time-list").on("click", "li", function(e) {
            $(".select-time-slot p").text($(e.target).text()); 
            $(".delivery-time-list").removeClass('toggleactive');
            $(".delivery-time-list").hide(); 
            $('#delivery_time_error').html('');

            $('#deliverytime').val($(this).data("deltime"));
        });

        function calcTime(city, offset) {
            var d = new Date();
            var utc = d.getTime() + (d.getTimezoneOffset() * 60000);
            var nd = new Date(utc + (3600000*offset));
            return nd;
        }

        function addDays(date, days) {
          var result = new Date(date);
          //console.log(days)
          //result.setDate(result.getDate() + days);
          result.setTime(result.getTime() +  (days * 24 * 60 * 60 * 1000));
          //console.log(result);
          return result;
        }

    //**** End for Delivery Type, Date and Time Section ***//

    //**** for Reviews Section ***//
    
        fetchReviews(productid, reviewPage);

        // Load more reviews on button click
        $('#load-more-btn').click(function() {
            reviewPage++;
            fetchReviews(productid, reviewPage);
        });

        function fetchReviews(productid, reviewPage) {
        
            $("#review-loader").show();
            isLoadingReview = true;
            
            $.ajax({
                
                url: '<?php echo e(route("fetch-reviews")); ?>',
                method: 'POST',
                data: {reviewPage: reviewPage, productid: productid, _token: '<?php echo e(csrf_token()); ?>'},
                
                success: function(response) {
                    console.log(response);
                    //if (response.html.length > 0) {
                    reviewTotalRecords = response.totalreview;

                    if (response.html) {
                        //$('.pcount').html(response.productscount);
                        $('#customer-reviews').append(response.html);
                        //reviewPage++;

                        if (reviewPage * reviewlimit >= reviewTotalRecords) {
                            $('.load-more-reviews').hide(); // Hide the load more button if no more data
                        }
                    } 
                    else {
                        //$(window).off('scroll'); // No more products to load
                        //$(window).off('scroll', handleScroll);
                        $('.load-more-reviews').hide();
                    }
                    isLoadingReview = false;
                    $("#review-loader").hide();
                    
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching products:', error);
                    isLoadingReview = false;
                    $("#review-loader").hide();
                }

            });
        }

    //**** End for Reviews Section ***//

});

//*** for Pincode Validation ***//

    function validatePincode(){
        $('#pincode').focus();
        $('#pincode-error').html('Please enter a valid 6-digit pincode.');
        $('#pincode-info').html('');
        $('.checkpin').removeClass('inactive-text');
        $('.successpin').addClass('inactive-text');
    }

//*** End for Pincode Validation ***//

//*** for the images ***//

    function openImage(evt, tabName) {
        let j, y, tablinks;
        y = document.getElementsByClassName("image-container");
        for (j = 0; j < y.length; j++) {
            y[j].style.display = "none";
        }
        tablinks = document.getElementsByClassName("thumblink");
        for (j = 0; j < y.length; j++) {
            tablinks[j].className = tablinks[j].className.replace(" selected", "");
        }
        document.getElementById(tabName).style.display = "block";
        evt.currentTarget.className += " selected";
    }

//*** End for the images ***//   

//**** for Product Atrribute Section ***//

    if($('.pro_attr').length){
        $('.pro_attr:checked').click();
    }

    $('.pro_attr').on('click', function() {
        //$('#price_tab').addClass('loading');
        var attr_id = $(this).data("attrid");
        //alert(attr_id);
        if ( attr_id != '' ) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '<?php echo e(route("attribute-details")); ?>',
                method: 'POST',
                data: {
                    attr_id: attr_id
                },
                success: function(data){
                    //alert(data);
                    if ( data != '' ) {
                        $('#product_attr_id').val(data.id);
                    }else{
                        $('#attribute-error').html('An error occurred during processing. Please try again.');
                    }
                }
            });
        }
    });

//**** End for Product Atrribute Section ***//

//*** for main product quantity ***//

    const mainMinusBtn = document.querySelectorAll('.main-minus-btn');
    const mainPlusBtn = document.querySelectorAll('.main-plus-btn');
    const prdDetquantityDisplay = document.querySelectorAll('.main-quantity');

    for(let i = 0 ; i < mainMinusBtn.length; i++){
        mainMinusBtn[i].addEventListener('click', function () {
          let mainquantity = parseInt(prdDetquantityDisplay[i].textContent);
          if (mainquantity > 1) {
            mainquantity--;
            prdDetquantityDisplay[i].textContent = mainquantity;
            $('#quantity').val(mainquantity);
          }
        });
        mainPlusBtn[i].addEventListener('click', function () {
          let mainquantity = parseInt(prdDetquantityDisplay[i].textContent);
            mainquantity++;
            prdDetquantityDisplay[i].textContent = mainquantity;
            $('#quantity').val(mainquantity);
        });
        
    }

//*** End for main product quantity ***//

//*** for the product info block ***//

    function openProductInfo(evt, tabName) {
        let i, x, tablinks;
        x = document.getElementsByClassName("tab-content");

        for (i = 0; i < x.length; i++) {
            x[i].style.display = "none";
        }
        tablinks = document.getElementsByClassName("tablink");
        for (i = 0; i < x.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" activeee", "");
        }
        document.getElementById(tabName).style.display = "block";
        evt.currentTarget.className += " activeee";
    }

//*** End for the product info block ***//

//**** for Extra Addon Part ***//

    var pro_extra_array = [];

    $('.extra-addon-cart-btn').click(function() {
        var xaddon = $(this).data("xaddon");
        var xaddonpid = $(this).data("xaddonpid");
        //console.log(xaddonpid);
        $('#fn-sec-'+xaddon).css('backgroundColor', '#fff');
        $('#fn-sec-'+xaddon).find('.prod-cart-btn').hide();
        $('#fn-sec-'+xaddon).find('.quantity-selector').show();

        extraaddon(xaddonpid, 1, 'positiveqty');
    })

    function extraaddon(id = 0, qty = 0, parameter){
        // var havepro = [];
        // var str = id + "|" + qty;
        // pro_extra_array.push(str);
        // console.log(pro_extra_array);

        var havepro = [];

        if (parameter == 'positiveqty') {
            
            var str = id + "|" + qty;
            itemExistsChecker(str, id);
            
        } else {
            
            for (var i = 0; i < pro_extra_array.length; i++) {
                havepro = pro_extra_array[i].split("|");
                if(havepro[0] == id){
                    str = id + "|" + havepro[1];
                    var cboxValueIndex = pro_extra_array.indexOf(str);
                    if (cboxValueIndex > -1) {
                        pro_extra_array.splice( cboxValueIndex, 1 );
                    }
                }
            }

        }

        console.log(pro_extra_array);

        //$('#scaddonqty' + id).val(qty);
        $('#product_extra_id').val(pro_extra_array);
    }

    function itemExistsChecker(pro_extra_id, id) {
        var len = pro_extra_array.length;
        var addonproductqty = pro_extra_id.split('|');
        var havepro = '';
        
        if (len > 0) {
            for (var i = 0; i < len; i++) {
                if (pro_extra_array[i] !== undefined) {
                    havepro = pro_extra_array[i].split("|");
                    
                    if(havepro[0] == addonproductqty[0]){
                        var cboxValueIndex = pro_extra_array.indexOf(pro_extra_array[i]);
                        if (cboxValueIndex > -1) {
                            pro_extra_array.splice( cboxValueIndex, 1 );
                        }
                        console.log(pro_extra_array);
                    } else {
                        
                        if (pro_extra_array[i] == pro_extra_id) {
                            return true;
                        }
                    }
                }
            }
        }
        
        pro_extra_array.push(pro_extra_id);
    }

    function changeQty(addonid, operation, inout, position){
        //alert("ff");
        //$('#add-btn-'+position).hide();
        //$('#fn-sec-'+xaddon).find('.prod-cart-btn').hide();
        var qty = parseInt($('#fn-sec-'+position).find('.xaddonQty').text());
        console.log(qty);

        if (operation == "plus") {
            qty++;
            //console.log(qty);
            $('#fn-sec-'+position).find('.xaddonQty').text(qty)
        }else{
            qty--;
            $('#fn-sec-'+position).find('.xaddonQty').text(qty)
            if (qty < 1) {
                $('#fn-sec-'+position).css('backgroundColor', '#056608');
                $('#fn-sec-'+position).find('.prod-cart-btn').show();
                $('#fn-sec-'+position).find('.quantity-selector').hide();
                $('#fn-sec-'+position).find('.xaddonQty').text(1);
            }
        }

        if(qty == 0){
            extraaddon(addonid, qty, 'zeroqty');
        }else{
            extraaddon(addonid, qty, 'positiveqty');
        }
    }

//**** End for Extra Addon Part ***//    

//**** for Personalized Image upload Section ***//

    $('#UploadedImg').val(<?php echo e(count($getUploadedPersonilizedImg)); ?>);
    var maxFilesValue = Number($('#NeedToUploadImg').val()) - Number($('#UploadedImg').val());

    //console.log(maxFilesValue);

    if($('#NeedToUploadImg').val() == $('#UploadedImg').val() && $('#personalizedImg').val() == 'uploaded-save'){
        $(".personalize-btn-section").hide();
        $(".edit-and-add-btn-section").show();
    }

    if(maxFilesValue === 0){
        $('#save').removeClass('inactive-text');
    }else{
        $('#save').addClass('inactive-text');
    }

    $('#personalize-btn, #edit-image-btn').click(function() {

        if($('#pincode').val() == '') {
            validatePincode();
            return false;
        }

        $('.drop-zone-overlay').fadeIn();
        $('#personalizeModal').css('display', 'block');
        setTimeout(function() {
            $('#personalizeModal').addClass('activee');
            //alert($('#NeedToUploadImg').val());
            //alert($('#UploadedImg').val());
            //alert(maxFilesValue);
        }, 10);
        $('body').css('overflow', 'hidden');
    });

    $('.drop-zone-overlay, #closeModalBtn, .reset').click(function() {
        $('.drop-zone-overlay').fadeOut();
        $('#personalizeModal').removeClass('activee');
        setTimeout(function() {
        $('#personalizeModal').css('display', 'none');
        $('body').css('overflow', 'unset');
        }, 300);
    });

    Dropzone.options.myDropzone = {
        url: '<?php echo e(route('uploadpersonalizedimg')); ?>', // Your server-side upload handler URL
        autoProcessQueue: false, // Automatically upload files
        addRemoveLinks: true,
        maxFiles: maxFilesValue,
        maxFilesize: 2, // Max file size in MB
        acceptedFiles: '.jpeg,.jpg', // Accept only images
        headers: {
            'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
        },
        init: function() {
            var myDropzone = this;

            myDropzone.on("sending", function(file, xhr, formData) {
                formData.append("product_id", $("#product_id").val());
            });
            
            myDropzone.on("addedfile", function(file) {
                //alert($('#UploadedImg').val());
                //alert(maxFilesValue);
                //alert(myDropzone.options.maxFiles);
                if (maxFilesValue === 0) {
                    // Remove the file if maxFiles is 0
                    myDropzone.removeFile(file);
                    //alert("No images can be uploaded.");
                } else if (myDropzone.files.length > maxFilesValue) {
                    // Remove the new file if it exceeds the maxFiles limit
                    myDropzone.removeFile(file);
                    alert("You cannot upload more than " + myDropzone.options.maxFiles + " images.");
                }else{

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var img = new Image();
                        img.onload = function() {
                            if (img.width < 1000 || img.height < 1000) {
                                myDropzone.processFile(file);
                            } else {
                                myDropzone.removeFile(file);
                                alert("Image dimensions must be less than or equal to 500x500 pixels.");
                            }
                        };
                        img.src = e.target.result;
                    };
                    reader.readAsDataURL(file);
                }
            });

            myDropzone.on("success", function(file, response) {
                // Handle successful uploads here
                console.log("File uploaded successfully", response);
                //document.getElementById('upload-success').style.display = 'block';
                // Remove all files from the Dropzone area
                //this.removeAllFiles(true);
                //$('.existing-image').hide()
                $('.appending-image').append('<div class="img-upld-div con-'+response.imgId+'"><div class="sub-upld-div"><div><img src="https://giftbasketsbrazil.rightflorist.org/uploaded/personalized_image/'+response.imgname+'"></div></div><div class="bin-div" id="binDiv" data-id = "'+response.imgId+'"><p>REMOVE</p></div></div>')
                $('#UploadedImg').val(response.noOfUploadImage);
                maxFilesValue = Number($('#NeedToUploadImg').val()) - Number($('#UploadedImg').val());
                // if($('#UploadedImg').val() == $('#NeedToUploadImg').val()){
                //     $('#save').removeClass('inactive-text');
                //     //alert("dd");
                // }

                if(maxFilesValue === 0){
                    $('#save').removeClass('inactive-text');
                }else{
                    $('#save').addClass('inactive-text');
                }
            });



            myDropzone.on("complete", function(file) {
              myDropzone.removeFile(file);
            });

            myDropzone.on("error", function(file, response) {
                // Handle errors here
                console.error("Error uploading file", response);
                $(file.previewElement).find('.dz-error-message').text(response.message || 'Error uploading file');
            });

            myDropzone.on("maxfilesexceeded", function(file) {
                this.removeFile(file);
                alert("No images can be uploaded.");
            });

            myDropzone.on("removedfile", function (file) {
                if (this.files.length < maxFilesValue) {
                    this.options.maxFiles = maxFilesValue - this.files.length;
                }
            });
        }
    };

    $('.personalizedImageContainer').on('click', '.bin-div', function(e) {    
        //alert("jj");
        e.preventDefault();
        var dataID = $(this).attr("data-id");
        var product_id = $("#product_id").val();
        if (confirm("Are you sure you want to remove this image?")) {
            $.ajax({
                url: "<?php echo e(route('deletepersonalizedimg')); ?>",
                method: 'POST',
                data: {dataID: dataID, product_id: product_id, _token: '<?php echo e(csrf_token()); ?>'},
                
                success: function(response) {
                    if(response.success){
                        //$('#imgexists').html('');
                        //$('#imgsec').html('');
                        //$('.personalizedImageContainer').remove(".con-"+dataID);
                        $("div.con-"+dataID).remove();
                        $('#UploadedImg').val(response.noOfUploadImage);
                        maxFilesValue = Number($('#NeedToUploadImg').val()) - Number($('#UploadedImg').val());
                        //alert($('#UploadedImg').val());
                        //alert(maxFilesValue);
                        if(maxFilesValue === 0){
                            $('#save').removeClass('inactive-text');
                        }else{
                            $('#save').addClass('inactive-text');
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching products:', error);
                }

            });
        }
    });

    $('#save').click(function() {
        $('.loader1').removeClass('inactive-text');
        $('#personalizedImg').val('uploaded-save');
        
        
        setTimeout(function() {
            $('.drop-zone-overlay').fadeOut();
            $('#personalizeModal').removeClass('activee');
            $('#personalizeModal').css('display', 'none');
            $('body').css('overflow', 'unset');
            $('.loader1').addClass('inactive-text')
        }, 600);
        if($('#NeedToUploadImg').val() == $('#UploadedImg').val() && $('#personalizedImg').val() == 'uploaded-save'){
            $(".personalize-btn-section").hide();
            $(".edit-and-add-btn-section").show();
        }
    });

//**** End for Personalized Image upload Section ***//    






$(".product_add_to_cart").on('click', function() {

    product_id                = $('#product_id').val();
    quantity                  = $('#quantity').val();
    product_attr_id           = $('#product_attr_id').val();
    product_extra_id          = $('#product_extra_id').val();
    delivery_delay_days       = $('#delDelayDays').val();
    delivery_type             = $('#deliverytype').val();
    delivery_time             = $('#deliverytime').val();
    product_delivery_date     = atob($('#deliverydate').val());
    ship_price                = $('#delCharge').val();
    delivery_pincode          = $('#pincode').val();
    delivery_city             = $('#deliverycityname').val();
    personalizedImg           = $('#personalizedImg').val();

    if(delivery_pincode == '') {
        validatePincode();
        return false;
    }

    if(product_delivery_date == '') {
        $('#delivery_date_error').html('Please Select Date');
        return false;
    }else{
        $('#delivery_date_error').html('');
    }

    if(delivery_time == '') {
        $('#delivery_time_error').html('Please Select Time');
        return false;
    }else{
        $('#delivery_time_error').html('');
    }

    <?php if($productPersonalize){ ?>
        if(personalizedImg != 'uploaded-save') {
            alert("Please upload and save image for the process")
            return false;
        }
    <?php } ?>

    <?php 
        $delivery_pincode_id = Session::get('Delivery.delivery_pincode_id');
    ?>

    <?php if($delivery_pincode_id<>''){ ?>
        if(delivery_pincode != <?php echo $delivery_pincode_id; ?>){
            if(confirm('You have products for another Pincode in the cart already, please finish that transaction before adding products for a different Pincode. If you choose "OK" your existing cart will be deleted.')){
                //return true;
            }else{
                return false;
            }
        }
    <?php }?>

    $('.loading-circle').removeClass('inactive-text');

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        url: '<?php echo e(route("check-gift-addon")); ?>',
        method: 'POST',
        data: {
            product_id: product_id,
        },
        success: function(data) {
            console.log(data);
            $('.loading-circle').addClass('inactive-text');

            if(data.hasgiftaddongroup == 'N'){
                
                $.ajax({
                    url: '<?php echo e(route("add-to-cart")); ?>',
                    method: 'POST',
                    data: {
                        product_id: product_id,
                        quantity: quantity,
                        product_attr_id: product_attr_id,
                        product_extra_id: product_extra_id,
                        delivery_delay_days: delivery_delay_days,
                        delivery_type: delivery_type,
                        delivery_time: delivery_time,
                        product_delivery_date: product_delivery_date,
                        delivery_pincode: delivery_pincode,
                        ship_price: ship_price,
                        delivery_city: delivery_city,
                        personalizedImg: personalizedImg,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(data) {
                        console.log(data);
                        
                        if( data.success ) {
                            setTimeout(function(){
                                window.location.href = '<?php echo e(route("cart")); ?>';
                            }, 1000);
                        }
                        else if( data.error ) {
                            console.log(data.error);
                        }
                    }
                });

            }else{
                document.getElementById("addon1").style.display = "block"; 
                $('.dual-ring-loader').removeClass('inactive-text');

                $.ajax({
                    url: '<?php echo e(route("gift-addon")); ?>',
                    method: 'POST',
                    data: {
                        product_id: product_id,
                        quantity: quantity,
                        product_attr_id: product_attr_id,
                        product_extra_id: product_extra_id,
                        delivery_delay_days: delivery_delay_days,
                        delivery_type: delivery_type,
                        delivery_time: delivery_time,
                        product_delivery_date: product_delivery_date,
                        delivery_pincode: delivery_pincode,
                        ship_price: ship_price,
                        delivery_city: delivery_city,
                        personalizedImg: personalizedImg,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(data) {
                        setTimeout(function(){
                            $('.dual-ring-loader').removeClass('inactive-text');
                            $('#list_gift_addons').html(data);
                        }, 1000);
                    }
                });
            }
        }
    });  





    // $.ajaxSetup({
    //     headers: {
    //         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //     }
    // });
    // $.ajax({
    //     url: '<?php echo e(route("add-to-cart")); ?>',
    //     method: 'POST',
    //     data: {
    //         product_id: product_id,
    //         quantity: quantity,
    //         product_attr_id: product_attr_id,
    //         product_extra_id: product_extra_id,
    //         delivery_delay_days: delivery_delay_days,
    //         delivery_type: delivery_type,
    //         delivery_time: delivery_time,
    //         product_delivery_date: product_delivery_date,
    //         delivery_pincode: delivery_pincode,
    //         ship_price: ship_price,
    //         delivery_city: delivery_city,
    //         personalizedImg: personalizedImg,
    //         _token: '<?php echo e(csrf_token()); ?>'
    //     },

    //     success: function(data) {
    //         $('.loading-circle').addClass('inactive-text');

    //         console.log(data);

    //         if( data.success ) {
    //             if(data.gift_addon == 0){
    //                 window.location.href = '<?php echo e(route("cart")); ?>';
    //             }else{

    //                 document.getElementById("addon1").style.display = "block"; 
    //                 $('.dual-ring-loader').removeClass('inactive-text');

    //                 $('#oid').val(data.oid);
    //                 $('#pid').val(data.pid);
    //                 $('#giftaddonstr').val(data.extra_addon_id);

    //                 setTimeout(function(){
    //                     $.ajaxSetup({
    //                         headers: {
    //                             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //                         }
    //                     });
    //                     $.ajax({
    //                         url: '/gift-addon',
    //                         method: 'POST',
    //                         data: {
    //                             order_id: data.oid,
    //                             product_id: product_id,
    //                             product_extra_id: product_extra_id,
    //                             _token: '<?php echo e(csrf_token()); ?>'
    //                         },
    //                         success: function(data) {
    //                             setTimeout(function(){
    //                                 $('.dual-ring-loader').removeClass('inactive-text');
    //                                 $('#list_gift_addons').html(data);
    //                             }, 1000);
    //                         }
    //                     });
    //                     //Gift Addon section
    //                 }, 1000);
    //             }
    //         }
    //     }
    // });
});

// For Add review modal
$('.add-review-button').click(function() {
    $("#rating_addon").fadeIn();
    $("body").addClass("modal-open");
});

$('#rating_popup_close').click(function() {
    $("#rating_addon").fadeOut();
    $("body").removeClass("modal-open");
})

$('#rating_addon').click(function(e) {
    if ($(e.target).closest(".modal-content").length === 0) {
        $('#rating_addon').fadeOut();
    }
})

$('#review_prod').on('click', function(e){
    e.preventDefault();
    var pid = $('#rvpid').val();
    var rtext = $('#rvtext').val();
    var rname = $('#rvname').val();
    var rvdel_location = $('#rvdel_location').val();
    var rvsender = $('#rvsender_location').val();
    var rvemail = $('#rvemail').val();
    var valuerate = $('input[type=radio][name="rating"]:checked').val();

    //alert(valuerate);

    if(rname.length < 1){
        $('.rtname').html('*Required');
    }else if(rtext.length < 1){
        $('.rtarea').html('*Required');
    }else if(!valuerate){
        $('.rtstar').html('*Please select the ratings above.');
    }else if(rvemail.length < 1){
        $('.rtemail').html('*Required');
    }else{
        $('.add-review-form').addClass('loading');
        $('.rtstar').html('');
        $('.rtname').html('');
        $('.rtarea').html('');
        $('.rtemail').html('');
        $.ajax({
            type : "POST",
            url : "<?php echo e(route('reviewpost')); ?>",
            data : {
                product_id : pid,
                user_name : rname,
                rating : valuerate,
                review : rtext,
                delplace : rvdel_location,
                fromplace : rvsender,
                email : rvemail
                },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success : function(response){
                console.log(response);
                //response = JSON.parse(response);
                if(response.status == 'success'){
                    $('.add-review-form').removeClass('loading');
                    $('.add-review-form')[0].reset();
                    $('.review-success').addClass('rvsc');
                    $('.review-success').html('Thank you for your reviews.');
                    setTimeout(function(){
                        $('.review-success').removeClass('rvsc');
                        // $('.review-success').html('Thank you for your reviews.');
                        $('.review-success').hide();
                        $("#rating_addon").fadeOut();
                        $("body").removeClass("modal-open");
                        location.reload();
                    }, 3000);
                }
            },
            error : function(){
            }
        });
    }

})

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.site.app', ['title' => $meta_title, 'meta_keyword' => $meta['meta_keyword'], 'meta_description' => $meta['meta_description']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/giftbasketsbrazil.rightflorist.org/resources/views/site/product/product_details.blade.php ENDPATH**/ ?>