<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php 
$currency = App\Http\Helper::get_currency();
$earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);
$reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
?>

<div class="prd-block" id="<?php echo e($product->id); ?>">

    <?php
        if($product->has_attribute == 'Y'){
            $prodPrice = App\Http\Helper::get_group_price( $product->id );
            $mainPrice = $prodPrice->price;
            $mrp = $prodPrice->actual_price;
        }else{
            $mainPrice = $product->price;
            $mrp = $product->actual_price;
        }
        //echo $mainPrice;
    ?>

    <?php if($mrp > 0 && ($mrp > $mainPrice)): ?>
        <?php $discount = (($mrp - $mainPrice)/$mrp) * 100; ?>
        <?php if(number_format($discount, 2) > 0): ?>
            <div class="product-discount">
                <p><?php echo e(number_format($discount, 1)); ?>% Off</p>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    
    <div class="prd-img-block">
        <a href="<?php echo e(url($product->slug)); ?>" target="_blank">
            <?php
        		$productDefaultImg = App\Http\Helper::getdefaultProductImage( $product->id );
            ?>
            <?php if(isset($productDefaultImg) && $productDefaultImg['name'] != null): ?>
                <?php if(file_exists(public_path('/uploaded/product/'.$productDefaultImg['name']))): ?>
                    <img fetchpriority='High' src="<?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?>" srcset="<?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 768w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1200w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1500w, <?php echo e(asset('uploaded/product/'.$productDefaultImg['name'])); ?> 1900w" imagesizes="" height="500" width="500" alt="<?php echo e($product->alt_key); ?>" loading="lazy">
                <?php else: ?>
                    <?php echo '<img class="img-fluid lazy" data-original="' . URL::to('/') . config('global.no_image') . '"  src="' . URL::to('/') . '/images/site/spinner.gif" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" height="500" width="500">'; ?>

                <?php endif; ?>
            <?php else: ?>
                <?php echo '<img class="img-fluid lazy" data-original="' . URL::to('/') . config('global.no_image') . '"  src="' . URL::to('/') . '/images/site/spinner.gif" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" height="500" width="500">'; ?>

            <?php endif; ?>
        </a>
    </div>
    <div class="prd-block-desc">
        <p>
            <?php if(strlen($product->product_name) > 34): ?>
                <?php echo e(substr($product->product_name, 0, 32)); ?>..
            <?php else: ?>
                <?php echo e($product->product_name); ?>

            <?php endif; ?>
        </p>
    </div>
    <?php if($reviewRating['rating'] > 0 ): ?>
        <div class="ratings">
            <div class="rating-yellow">
                <?php
                    $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                ?>
                <?php for($k=1; $k<=5; $k++): ?>
                    <?php if( $avgRating >= $k): ?>
                        <span class="gold">&#9733;</span>
                    <?php else: ?>
                        <span class="grey">&#9733;</span>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        </div>
    <?php endif; ?>
    
    <div class="msz-del <?php if($reviewRating['rating'] > 0 ): ?> rating-padding <?php endif; ?>">
        Earlist Delivery : <?php echo e($earliestDelivery); ?>

    </div>
    <div class="btn-price flex">
        <div class="prd-price-box flex">

            <div class="price-tag">

                <div class="home-price flex main-price-section"> 
                    <?php if($mrp > $mainPrice): ?>
                        <div class="price-tag old-price"><?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?></div>
                    <?php endif; ?>
                    <div class="price-tag">
                        <?php echo Currency::default($product->price, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?>

                    </div>
                </div>

                

                <?php foreach($currency as $cur){ ?>

                    <div class="home-price flex <?php echo e(strtolower($cur->symbol)); ?>-price-section currencyClass" style="display:none;"> 
                        <?php if($mrp > $mainPrice): ?>
                            <div class="price-tag old-price"><?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit'), 'currency' => $cur->symbol]); ?></div>
                        <?php endif; ?>
                        <div class="price-tag">
                            <?php echo Currency::default($mainPrice, ['need_currency' => false, 'number_format' => config('global.number_format_limit'), 'currency' => $cur->symbol]); ?>

                        </div>
                    </div>
                <?php } ?>

                

            </div>

            <div class="price-select select ">
                <select name="curChange" id="curChange<?php echo e($product->id); ?>" class="curChange noOutlineDropdown">
                    <?php foreach($currency as $value){ ?>
                        <option value="<?php echo e($value->currency); ?>" 
                        <?php echo (Request::session()->get('currency')==$value->currency) ? 'selected' : '' ; ?>  >
                        <?php echo e($value->currency); ?></option>
                    <?php } ?>
                </select>
            </div>

        </div>
        <div class="btn-section">
            <a href="<?php echo e(url($product->slug)); ?>">ADD TO CART</a>
        </div>
    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script src="<?php echo e(asset('site/js/lazyload.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $("img.lazy").lazyload();

        if($('#active_currency').val() == ''){
            $('.main-price-section').show();
            $('.currencyClass').hide();
        } else if($('#active_currency').val() != ''){
        	var curName = $('#active_currency').val().toLowerCase();
            $('.main-price-section').hide();
            $('.currencyClass').hide();
            $('.'+curName+'-price-section').show();
        }

    });

    $(document).ready(function() {
        //$('.curChange').on('change', function() {
        $(".curChange").change(function () {
            //alert(this.value);
            if(this.value != ''){
                $.ajax({
                    type : "GET",
                    url : "<?php echo e(route('set_currency')); ?>/?currency="+this.value,
                    success : function(response){
                        console.log(response);
                        response = JSON.parse(response);
                        if(response.status == 'success'){
                            $('#active_currency').val(response.currency);

                            var activeCurName = response.currency.toLowerCase();
                            if(response.currency != ''){
                            	$('.main-price-section').hide();
                            	$('.currencyClass').hide();
                            	$('.'+activeCurName+'-price-section').show();
                            	$('.curChange option[value="'+ response.currency +'"]').prop('selected', true);
                            }
                        }
                    },
                    error : function(){
                    }
                });
            }
        });
    });
</script><?php /**PATH /home/rightflorist/public_html/giftbasketsgermany.rightflorist.org/resources/views/site/product/loadmore.blade.php ENDPATH**/ ?>