<?php
$total_shipping_price = 0;
$currency = App\Http\Helper::get_currency();
if( !empty( $ordersummary ) ) {
?>

<div class="review-currency">

    <select class="currency_rev noOutlineDropdown">
        <?php $__currentLoopData = $currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($value->currency); ?>" <?php echo (Request::session()->get('currency')==$value->currency) ? 'selected' : '' ; ?>><?php echo e($value->currency); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


<div class="shopping-cartn p-2 bg-light cart-review">
   <table border="1" bordercolor="#ddd" align="center">
	  	<tbody>
			<tr>
				<th scope="col">Image</th>
				<th scope="col">Product Name</th>
				<th scope="col">Quantity</th>
				<th scope="col">Unit Price</th>
				<th scope="col">Shipping</th>
			</tr>

		 	<?php
	        foreach ( $ordersummary['item_dtl'] as $data ) {
	            $total_shipping_price = $total_shipping_price + $data['ship_price'];
    		?>
		 	<tr>
				<td>
				   <?php if(isset($data['image']) && $data['image'] != null ): ?>
                   <?php if(file_exists(public_path('/uploaded/product/'.$data['image']))): ?>
                       <?php echo '<img src="' . URL::to('/') . '/uploaded/product/' . $data['image'] . '" >'; ?>

                   <?php else: ?>
                       <?php echo '<img src="' . URL::to('/').config('global.no_image') . '" >'; ?>

                   <?php endif; ?>
               <?php else: ?>
                   <?php echo '<img src="'.URL::to('/').config('global.no_image').'" >'; ?>

               <?php endif; ?>

               
				</td>
				<td>
				   <p class="ptitle">
				   	<?php echo e($data['product_name']); ?> <br>
	               <?php
							if( $data['attribute_name'] != '' ) {
							   echo '('.$data['attribute_name'].')';
							}
	               ?>
				   </p>
				</td>
				<td class="no-wrap"><?php echo e($data['qty']); ?></td>
				<td>
					<?php echo Currency::default($data['total_price'], ['need_currency'=>true, 'number_format'=>config('global.number_format_limit') ]); ?>
				</td>
				<td>
					<?php
	            if( $data['ship_price'] != 0 ) {
	                echo Currency::default($data['ship_price'], ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
	            }
	            else {
	                echo "Free";
	            }
	            ?>
				</td>
		 	</tr>
		 	<?php
		      }
		   ?>
	  	</tbody>
   </table>
</div>

<div class="shopping-cartn cart-calculate">
    <table>
    <tr>
        <td>&nbsp;</td>
        <td>Sub-Total:  </td>
        <td>
            <?php
                $final_price = 0;

                $final_price = $ordersummary['total_cart_price'];
                
                echo Currency::default($ordersummary['total_cart_price'], ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
            ?>
        </td>
    </tr>
    <?php
        if( $total_shipping_price != 0 ) {
    ?>
    <tr>
        <td>&nbsp;</td>
        <td>Shipping :</td>
        <td>
            <?php
                echo Currency::default($total_shipping_price, ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
            ?>
        </td>
    </tr>
    <?php
        }
    ?>
    <?php
    $discount_amount = 0;
    $coupondata = App\Http\Helper::get_coupon_details( $ordersummary['order_id'] );
    if( $coupondata != null ) {
    ?>
    <tr>
        <td>&nbsp;</td>
        <td>Discount:</td>
        <td>
            <?php
                if( $coupondata != null ) {
                    if( $coupondata->applied_for == 'WC' ) {   //If coupon related to whole Cart
                        if( $coupondata->coupon_detail->type == 'F' ) {
                            $discount_amount = number_format($coupondata->coupon_detail->amount, 2);;
                        }else {
                            $discount_amount = number_format((( $ordersummary['total_cart_price'] * $coupondata->coupon_detail->amount ) / 100), 2);
                        }
                    }
                    else{   //If coupon related to Occasion only
                        $total_related_products_price = 0;
                        $total_related_products_price = App\Http\Helper::get_selected_occasion_related_coupon_details($coupondata->coupon_id);
                        
                        if( $total_related_products_price > 0 ) {
                            if( $coupondata->coupon_detail->type == 'F' ) {
                                $discount_amount = $total_related_products_price - $coupondata->coupon_detail->amount;
                            }else {                                                
                                $discount_amount = ( $total_related_products_price * $coupondata->coupon_detail->amount ) / 100;
                            }
                        }
                    }
                    echo Currency::default($discount_amount, ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);

                    //Setting coupon discount amount in session
                    Session::put('coupon_discount_amount',$discount_amount);
                }
            ?>
        </td>
    </tr>
    <?php
        }
    ?>
    <tr>
        <td>&nbsp;</td>
        <td><strong>Grand Total:</strong></td>
        <td><strong>
            <?php
                $final_price = $ordersummary['total_cart_price'] - $discount_amount + $total_shipping_price;

                echo Currency::default($final_price, ['need_currency' => true, 'number_format' => config('global.number_format_limit') ]);
            ?>
        </strong></td>
    </tr>
    </table>
</div>



<?php
}
else{
?>
    <h3 class="fs-subtitle" style="color: red;">There are no products found in your cart.</h3>
    <a href="<?php echo e(url('/')); ?>" class="btns button-blue" >Continue Shopping</a>
<?php
}
?>

<script type="text/javascript">

    $('.currency_rev').on('change', function() {
        //alert( this.value );
        var currency_data = this.value;
        var mes_id     = $('#message_id').val();
            $('#order_summary_fieldset_loader').addClass('loading');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '<?php echo e(route("set_currency_order_summary")); ?>',
                type: 'POST',
                dataType: 'HTML',
                data: {
                    currency_data: currency_data
                },
                success: function(response_order_summary) {
                    if(response_order_summary){
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: '<?php echo e(route("checkout-step-order-summary")); ?>',
                            type: 'POST',
                            dataType: 'HTML',
                            data: {
                                message_id: mes_id
                            },
                            success: function(response_order_summary) {
                                setTimeout(function() {
                                    $('#order_summary').html(response_order_summary);
                                    $('#order_summary_fieldset_loader').removeClass('loading');
                                }, 10);
                            }
                        });
                    }
                }
            });
    });


    $(document).ready(function() {

        $("#orderPlaced").validate({
            rules: {                    
            },
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
        });
    });
	
	
    </script><?php /**PATH /home/u528937722/domains/yashrathi.com/public_html/resources/views/site/checkout/order_summary.blade.php ENDPATH**/ ?>