<?php
$currency = App\Http\Helper::get_currency();
?>




<?php $__env->startSection('content'); ?>

<!--index banner-->
<section class="home-banner">
    <div class="home-bg-banner">
        <div class="bg-lft-ban" onClick="window.location.href='<?php echo e(url('/birthday')); ?>'">
            <div class="image"><img src="<?php echo e(asset('images/Birthday-slide.webp')); ?>" alt="Birthday Gifts"></div>
            <div class="bg-lft-txt banner-txt">
                <div class="bg-bold">Birthday</div>
                <div class="bg-light">Gift Baskets</div>
                <!-- <div class="bg-sm-txt left-txt">Lorem ipsum dolor sit, amet consectetur adipisicing elit.</div> -->
                <div class="shop-now" style="clear:both"><a href="<?php echo e(url('/birthday')); ?>">Shop Now</a></div>
            </div>
        </div>
        <div class="bg-rgt-ban" onClick="window.location.href='<?php echo e(url('/gourmet')); ?>'">
            <div class="image"><img src="<?php echo e(asset('images/main-slide.webp')); ?>" alt="Gourmet Gifts"></div>
            <div class="bg-rgt-txt banner-txt res-ban-txt">
                <div class="bg-light-rgt">Gourmet</div>
                <div class="bg-bold-rgt">Gift Baskets</div>
                <!-- <div class="bg-sm-txt">Lorem ipsum dolor sit, amet consectetur adipisicing elit.</div> -->
                <div class="shop-now"><a href="<?php echo e(url('/gourmet')); ?>">Shop Now</a></div>
            </div>
        </div>
    </div>
    <div class="home-sm-banner">
        <div class="sm-ban-container" onClick="window.location.href='<?php echo e(url('/corporate-gifts')); ?>'">
            <div class="image"><img src="<?php echo e(asset('images/Corporate-slide.webp')); ?>" alt="Corporate Gifts"></div>
            <div class="sm-ban-txtbox">
                <div class="sm-bold">Corporate</div>
                <div class="sm-light">Gift Baskets</div>
                <!-- <div class="smban-txt">Lorem ipsum dolor sit, amet consectetur adipisicing elit. </div> -->
                <div class="shop-now-sm"><a href="<?php echo e(url('/corporate-gifts')); ?>">Shop Now</a></div>
            </div>
        </div>
        <div class="sm-ban-container" onClick="window.location.href='<?php echo e(url('/non-alcoholic')); ?>'">
            <div class="image"><img src="<?php echo e(asset('images/Alcoholfree-slide.webp')); ?>" alt="Alcohol Free Gifts"></div>
            <div class="sm-ban-txtbox">
                <div class="sm-bold">Alcoholfree</div>
                <div class="sm-light">Gift Baskets</div>
                <!-- <div class="smban-txt">Lorem ipsum dolor sit, amet consectetur adipisicing elit. </div> -->
                <div class="shop-now-sm"><a href="<?php echo e(url('/non-alcoholic')); ?>">Shop Now</a></div>
            </div>
        </div>
        <div class="sm-ban-container" onClick="window.location.href='<?php echo e(url('/gift-baskets')); ?>'">
            <div class="image"><img src="<?php echo e(asset('images/Romantic-slide.webp')); ?>" alt="Romantic Gifts"></div>
            <div class="sm-ban-txtbox">
                <div class="sm-bold">Romantic</div>
                <div class="sm-light">Gift Baskets</div>
                <!-- <div class="smban-txt">Lorem ipsum dolor sit, amet consectetur adipisicing elit. </div> -->
                <div class="shop-now-sm"><a href="<?php echo e(url('/gift-baskets')); ?>">Shop Now</a></div>
            </div>
        </div>
    </div>
</section>

<?php if( count($featured_category) > 0 ): ?>
<?php $t = 1; $position = 1; ?>
<?php $__currentLoopData = $featured_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
//echo $category->category_id;
$product_list = App\Http\Helper::getHomepageProductsByCatId( $category->category_id, $category->data_limit);
//dd($product_list);
?>

<?php if( count($product_list['product']) > 0 ): ?>
<section class="home-products">
    <div class="hp-heading flex">
        <div class="hph-txt">
            <h2><?php echo e($category->title); ?></h2>
            <p><?php echo e($category->description); ?></p>
        </div>
    </div>
    <div class="prd-container">
        <!--product block-->
        <?php $__currentLoopData = $product_list['product']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php
        $reviewRating = App\Http\Helper::getProductReviewNRating($product->id);
        ?>

        <?php
        if ($product->has_attribute == 'Y') {
            $prodPrice = App\Http\Helper::get_group_price($product->id);
            $mainPrice = $prodPrice->price;
            $mrp = $prodPrice->actual_price;
        } else {
            $mainPrice = $product->price;
            $mrp = $product->actual_price;
        }
        //echo $mainPrice;
        ?>

        <div class="prd-block" id="<?php echo e($product->id); ?>">
            <?php if($mrp > 0 && ($mrp > $mainPrice)): ?>
            <?php $discount = (($mrp - $mainPrice)/$mrp) * 100; ?>
            <?php if(number_format($discount, 2) > 0): ?>
            <div class="product-discount">
                <p><?php echo e(number_format($discount, 1)); ?>% OFF</p>
            </div>
            <?php endif; ?>
            <?php endif; ?>
            <div class="prd-img-block">
                <a href="<?php echo e(url('/'.$product->slug)); ?>" target="_blank">
                    <?php if( $product->default_product_image != null ): ?>
                    <?php if(file_exists(public_path('/uploaded/product/'.$product->default_product_image['name']))): ?>
                    <img fetchpriority='High' src="<?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?>" srcset="<?php echo e(asset('uploaded/product/thumb/'.$product->default_product_image['thumb'])); ?> 768w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1200w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1500w, <?php echo e(asset('uploaded/product/'.$product->default_product_image['name'])); ?> 1900w" imagesizes="" height="500" width="500" alt="<?php echo e($product->alt_key); ?>" loading="lazy">
                    <?php else: ?>
                    <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500">'; ?>

                    <?php endif; ?>
                    <?php else: ?>
                    <?php echo '<img class="img-fluid" src="' . URL::to('/').config('global.no_image'). '" alt="'. $product->alt_key .'" title="'. $product->alt_key .'" loading="lazy" height="500" width="500">'; ?>

                    <?php endif; ?>
                </a>
            </div>
            <div class="prd-block-desc">
                <p>
                    <?php if(strlen($product->product_name) > 50): ?>
                    <?php echo e(substr($product->product_name, 0, 48)); ?>..
                    <?php else: ?>
                    <?php echo e($product->product_name); ?>

                    <?php endif; ?>
                </p>
            </div>
            <?php if($reviewRating['rating'] > 0 ): ?>
            <div class="ratings">
                <div class="rating-yellow">
                    <?php
                    $avgRating = round($reviewRating['rating']/$reviewRating['review'], 0);
                    ?>
                    <?php for($k=1; $k<=5; $k++): ?> <?php if( $avgRating>= $k): ?>
                        <span class="gold">&#9733;</span>
                        <?php else: ?>
                        <span class="grey">&#9733;</span>
                        <?php endif; ?>
                        <?php endfor; ?>
                </div>
            </div>
            <?php endif; ?>
            <div class="msz-del <?php if($reviewRating['rating'] > 0 ): ?> rating-padding <?php endif; ?>">
                <?php
                $earliestDelivery = App\Http\Helper::get_earliest_delivery_date($product->delivery_delay_days, $product->id);
                ?>
                Earlist Delivery: <?php echo e($earliestDelivery); ?>

            </div>
            <div class="btn-price flex">
                <div class="prd-price-box flex">
                    <div class="price-tag">

                        <div class="home-price flex main-price-section">
                            <?php if($mrp > $mainPrice): ?>
                            <div class="price-tag old-price"><?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?></div>
                            <?php endif; ?>
                            <div class="price-tag">
                                <?php echo Currency::default($product->price, ['need_currency' => false, 'number_format' => config('global.number_format_limit')]); ?>

                            </div>
                        </div>

                        

                        <?php foreach ($currency as $cur) { ?>

                            <div class="home-price flex <?php echo e(strtolower($cur->symbol)); ?>-price-section currencyClass" style="display:none;">
                                <?php if($mrp > $mainPrice): ?>
                                <div class="price-tag old-price"><?php echo Currency::default($mrp, ['need_currency' => false, 'number_format' => config('global.number_format_limit'), 'currency' => $cur->symbol]); ?></div>
                                <?php endif; ?>
                                <div class="price-tag">
                                    <?php echo Currency::default($mainPrice, ['need_currency' => false, 'number_format' => config('global.number_format_limit'), 'currency' => $cur->symbol]); ?>

                                </div>
                            </div>
                        <?php } ?>

                        

                    </div>

                    <div class="price-select select ">
                        <select name="curChange" id="curChange<?php echo e($product->id); ?>" class="curChange noOutlineDropdown">
                            <?php foreach ($currency as $value) { ?>
                                <option value="<?php echo e($value->currency); ?>" <?php echo (Request::session()->get('currency') == $value->currency) ? 'selected' : ''; ?>>
                                    <?php echo e($value->currency); ?>

                                </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="btn-section">
                    <a href="<?php echo e(url('/'.$product->slug)); ?>" target="_blank">ADD TO CART</a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <!--product block ends-->

        <!--last product banner-->
        <div id="cakes-banner">
            <a href="<?php echo e(url('/'.$category->slug)); ?>" title="More Gifts">
                <img class="ban-img" src="<?php echo e(asset('images/'.$category->banner)); ?>" alt="More Gifts" width="400" height="400" />
                <div class="more-products"><span>More Products</span></div>
            </a>
        </div>
        <!--last product banner ends-->
    </div>
</section>
<?php endif; ?>

<?php if( $t == 1 ): ?>

<!---FAQ section-->
<div class="accordion-section ">
    <div class="accordion-sub">
        <p class="question1">FAQ</p>
        <p class="question2">Frequently Asked Questions</p>
    </div>
    <div class="accordion">
        <div class="accordion-content">
            <header>
                <span class="title">Can I customize the contents of a gift basket?</span>
                <!--<i class="fa-solid fa-plus"></i>--->
                <i class="fa-solid fa-angle-down"></i>
            </header>

            <p class="description">
                Yes, we offer the option to customize the contents of select gift baskets.<br>
                You can choose from a variety of available items and create a personalized gift basket tailored to your recipient's preferences.
            </p>
        </div>

        <div class="accordion-content">
            <header>
                <span class="title">Can I track the status of my order?</span>
                <i class="fa-solid fa-angle-down"></i>
            </header>

            <p class="description">
                Absolutely! Once your order is confirmed and shipped, you will receive a tracking number via email. This tracking number can be used to monitor the status and location of your package.
            </p>
        </div>
        <div class="accordion-content">
            <header>
                <span class="title">Can I ship gift baskets to multiple addresses?</span>
                <i class="fa-solid fa-angle-down"></i>
            </header>

            <p class="description">
                Yes, we offer the convenience of shipping gift baskets to multiple addresses.<br>
                During the checkout process, you will have the option to add multiple shipping addresses. Simply provide the necessary details for each address, select the desired gift basket for each recipient, and proceed with the order. This allows you to easily send thoughtful gifts to multiple locations without any hassle.
            </p>
        </div>
        <div class="accordion-content">
            <header>
                <span class="title">Are the gift baskets packaged securely to ensure the items are not damaged during transit?</span>
                <i class="fa-solid fa-angle-down"></i>
            </header>

            <p class="description">
                Absolutely! We take great care in packaging our gift baskets to ensure they arrive in pristine condition.<br>Each gift basket is carefully arranged and securely packaged to protect the items during transit. We use high-quality packaging materials and cushioning to safeguard delicate items and prevent any damage during shipping. Rest assured that your gift basket will be delivered intact and ready to impress the recipient.
        </div>
    </div>
</div>
<div class="faq">
    <button class="faq-btn">MORE &nbsp;<span><i class="fa-solid fa-caret-down"></i></span></button>
    <div class="faq-body">
        <button class="faq-cross">X</button>
        <div class="faq-text-div">
            <h2>About</h2>
            <p>GiftBasketsGermany.de is an Online Gift Store that delivers Gifts and Flowers all over Germany. We deliver best quality Gifts and fresh cut Flowers in more than 150 cities across Germany with the help of our strong affiliate network and channel stores. Each and every one of our Flowers is handpicked at the right stage of bloom by our expert Florists in your cities.

                Our online Gifts and Flowers delivery platform comprises of a team with strong technological and operations experience which enables us to deliver Gifts and fresh Flowers at the cheapest prices available in Germany. In addition to delivering Gifts and Flowers, we also strive to make that special occasion for you and your loved ones even more special by delivering surprise Gifts like Cakes, Chocolates, Teddy Bears, Sweets etc.

                GiftBasketsGermany.de is always there where "Love is a Celebration of Life". We know how important it is to express your feelings with the same amount of zeal that your presence would have brought to the occasion. Bringing a smile on your face and being your messenger with perfection is our motto. We define our success by our satisfied customers. We can proudly say that we have more than 20000 satisfied Customers all over Germany. Our extraordinary Service, our Payment Modes and our Quality all have made us one of the most popular household names in Germany.
            </p>
        </div>
    </div>
</div>

<?php elseif( $t == 3 ): ?>

<!--middle banner of delivery-->
<!-- <div class="middle-banner">
    <div class="middle-first-banner">
        <div class="middle-banner-img"><i class="fa-solid fa-car"></i></div>
        <div class="middle-banner-text">
            <p>Guranteed Delivery</p>
        </div>
    </div>
    <div class="middle-second-banner">
        <div class="middle-banner-img"> <i class="fa-regular fa-money-bill-1"></i> </div>
        <div class="middle-banner-text">
            <p>Hassle Free Delivery</p>
        </div>
    </div>
    <div class="middle-third-banner">
        <div class="middle-banner-img"> <i class="fa-solid fa-globe"></i> </div>
        <div class="middle-banner-text">
            <p>100% Secure Payments</p>
        </div>
    </div>
    <div class="middle-fourth-banner">
        <div class="middle-banner-img"> <i class="fa-solid fa-headphones"></i> </div>
        <div class="middle-banner-text">
            <p>100% Secure Payments</p>
        </div>
    </div>
</div> -->
<div class="middle-banner">
    <div class="middle-first-banner">
        <div class="middle-banner-img">
            <span><img src="<?php echo e(asset('images/Assured-Delivery.webp')); ?>"></span>
        </div>
        <div class="middle-banner-text">
            <p>Assured Delivery</p>
        </div>
    </div>
    <div class="middle-second-banner">
        <div class="middle-banner-img">
            <span><img src="<?php echo e(asset('images/100-Secure-Payments.webp')); ?>"></span>
        </div>
        <div class="middle-banner-text">
            <p>100% Secure Payments</p>
        </div>
    </div>
    <div class="middle-third-banner">
        <div class="middle-banner-img">
            <span><img src="<?php echo e(asset('images/24-7-Customer-Service.webp')); ?>"></span>
        </div>
        <div class="middle-banner-text">
            <p>24x7 Customer Service</p>
        </div>
    </div>
    <div class="middle-fourth-banner">
        <div class="middle-banner-img">
            <span><img src="<?php echo e(asset('images/Best-Prices.webp')); ?>"></span>
        </div>
        <div class="middle-banner-text">
            <p>Best Prices</p>
        </div>
    </div>
</div>

<?php endif; ?>

<?php if( $t % 2 == 0 ): ?>

<?php if($position == 0): ?>



<?php endif; ?>

<?php
$position++;
?>

<?php endif; ?>

<?php
$t++;
?>


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<!---Banner slider---->
<section class="banner-slider">
    <img class="banner-slider-img" src="<?php echo e(asset('images/carousel_banner.webp')); ?>" alt="" width="1900" height="600">
    <img class="banner-slider-img-mobile" src="<?php echo e(asset('images/mobile-banner-min.webp')); ?>" alt="" width="600" height="600">
    <div class="owl-carousel owl-theme banner-slider-txt">
        <div class="bst-inner">
            <p class="bst-txt2">Fresh Flowers</p>
            <p class="bst-txt1">Send Flowers to Germany</p>
            <a href="<?php echo e(url('/flowers')); ?>">Buy Now</a>
        </div>
        <div class="bst-inner">
            <p class="bst-txt2">Gourmet Gifts </p>
            <p class="bst-txt1">Send Gourmet Gifts to Germany</p>
            <a href="<?php echo e(url('/gourmet')); ?>">Buy Now</a>
        </div>
        <div class="bst-inner">
            <p class="bst-txt2">Chocolates</p>
            <p class="bst-txt1">Send Chocolates to Germany</p>
            <a href="<?php echo e(url('/chocolates')); ?>">Buy Now</a>
        </div>
    </div>
</section>

<!---shop by categories---->
<section class="shop-by-cat">
    <div class="sbc-heading">
        <div class="sbch-txt">
            <p>Unleash the Meaningful Range of Gift Baskets</p>
            <h5 class="sub-heading">Send Heartfelt Gifts to Germany, Conveying Your Deepest Sentiments</h5>
        </div>
    </div>
    <div class="sbc-body clearfix">
        <a href="<?php echo e(url('/flowers')); ?>" title="Fresh Flowers" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_flowers_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Fresh Flowers</h3>
        </a>
        <a href="<?php echo e(url('/wines')); ?>" title="Wine Gift Baskets" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_wines_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Wine Gift</h3>
        </a>
        <a href="<?php echo e(url('/chocolates')); ?>" title="Chocolates" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_chocolates_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Chocolates</h3>
        </a>
        <a href="<?php echo e(url('/fruit-baskets')); ?>" title="Fruit Gift Baskets" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_fruits_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Fruit Gift</h3>
        </a>
        <a href="<?php echo e(url('/christmas')); ?>" title="Christmas Gifts" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_christmas_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Christmas Gifts</h3>
        </a>
        <a href="<?php echo e(url('/birthday')); ?>" title="Birthday Gifts" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_birthdat_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Birthday</h3>
        </a>
        <a href="<?php echo e(url('/gift-baskets')); ?>" title="Love and Romance" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_love_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Love and Romance</h3>
        </a>
        <a href="<?php echo e(url('/non-alcoholic')); ?>" title="Non Alcoholic Hamper" class="sbc-box">
            <div class="sbcb-cat">
                <img src="<?php echo e(asset('images/bottom_nonalcohol_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Non Alcoholic</h3>
        </a>
    </div>
</section>

<!---shop by price---->
<section class="shop-by-price">
    <div class="sbp-heading">
        <div class="sbph-txt">
            <p>Explore Gifts for Every Budget</p>
            <h5 class="sub-heading">Find Perfect Gifts Within Your Budget for Germany Delivery</h5>
        </div>
    </div>
    <div class="sbp-body clearfix">
        <a href="<?php echo e(asset('under-$75')); ?>" class="sbp-box">
            <div class="sbpb-cat">
                <img src="<?php echo e(asset('images/under_75.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Under $75</h3>
        </a>
        <a href="<?php echo e(asset('under-$125')); ?>" class="sbp-box">
            <div class="sbpb-cat">
                <img src="<?php echo e(asset('images/under_125.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Under $125</h3>
        </a>
        <a href="<?php echo e(asset('under-$175')); ?>" class="sbp-box">
            <div class="sbpb-cat">
                <img src="<?php echo e(asset('images/under_175.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Under $175</h3>
        </a>
        <a href="<?php echo e(asset('over-$175')); ?>" class="sbp-box">
            <div class="sbpb-cat">
                <img src="<?php echo e(asset('images/over_175.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Over $175</h3>
        </a>
    </div>
</section>

<!---shop by relation---->
<section class="shop-by-relation">
    <div class="sbr-heading">
        <div class="sbrh-txt">
            <p>Thoughtful Gifts for Every Connection in Germany</p>
            <h5 class="sub-heading">Discover a Diverse Assortment of Gifts for Meaningful Relations</h5>
        </div>
    </div>
    <div class="sbr-body clearfix">
        <a href="<?php echo e(url('/him')); ?>" class="sbrb-box">
            <div class="sbrb-cat">
                <img src="<?php echo e(asset('images/forhim_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>For Him</h3>
        </a>
        <a href="<?php echo e(url('/her')); ?>" class="sbrb-box">
            <div class="sbrb-cat">
                <img src="<?php echo e(asset('images/forher_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>For Her</h3>
        </a>
        <a href="<?php echo e(url('/kids')); ?>" class="sbrb-box">
            <div class="sbrb-cat">
                <img src="<?php echo e(asset('images/forkids_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>For Kids</h3>
        </a>
        <a href="<?php echo e(url('/corporate-gifts')); ?>" class="sbrb-box">
            <div class="sbrb-cat">
                <img src="<?php echo e(asset('images/corporate_ban.webp')); ?>" alt="" width="408" height="410">
            </div>
            <h3>Corporate</h3>
        </a>
    </div>
</section>

<!--Testimonial-->
<section class="testimonials">
    <div class="testimonial-div">
        <p class="t-head">Testimonials</p>
        <span class="divider"></span>
    </div>

    <div class="t-body owl-carousel owl-theme flex">
        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="test-sec">
            <h3><?php echo $testimonial->name; ?></h3>
            <div class="tst-date-loc">
                <p>From : <?php echo $testimonial->place; ?></p>
                <p>Delivery To : <?php echo $testimonial->send_place; ?></p>
            </div>
            <p><?php echo $testimonial->content; ?></p>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

</section>

<!--Writeup-->
<section class="content">
    <div class="con-sec">
        <?php echo $home_bottom_content->content; ?>

    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $('.currencyClass').hide();
    });

    $('.curChange').on('change', function() {
        //alert(this.value);
        if (this.value != '') {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('set_currency')); ?>/?currency=" + this.value,
                success: function(response) {
                    //console.log(response);
                    response = JSON.parse(response);
                    if (response.status == 'success') {
                        $('#active_currency').val(response.currency);

                        var activeCurName = response.currency.toLowerCase();

                        if (response.currency != '') {
                            $('.main-price-section').hide();
                            $('.currencyClass').hide();
                            $('.' + activeCurName + '-price-section').show();
                            $('.curChange option[value="' + response.currency + '"]').prop('selected', true);
                        }
                    }
                },
                error: function() {}
            });
        }
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.site.app', ['title' => $home_bottom_content->meta_title, 'meta_keyword' => $home_bottom_content->meta_keyword, 'meta_description' => $home_bottom_content->meta_description], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/giftbasketsgermany.rightflorist.org/resources/views/site/home.blade.php ENDPATH**/ ?>