<?php
$meta_data['keyword'] = $contact_us->meta_keyword;
$meta_data['description'] = $contact_us->meta_description;
$meta_title = $contact_us->meta_title;
?>
<?php $meta = App\Http\Helper::get_meta($meta_data); ?>
<?php $gencode = App\Http\Helper::contactCapcha(); ?>


<?php $__env->startSection('content'); ?>

<ul class="breadcrumb">
    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
    <li>Contact Us</li>
</ul>

<div class="contact-container">
  <div class="contact-lt">
    <div class="lt-head">Contact Us</div>
    <div class="lt-body">

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($message); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(Session::has('alert-' . $msg)): ?>
                <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <form method="POST" action="<?php echo e(route('contact-us')); ?>" id="contactUs" class="contact-form" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="con-field">
            <div class="title"><sup>*</sup><label>Type of Query :</label></div>
            <div class="field-body">
                <select name="contact_type" id="contact_type" required="" >
                    <option value="">Please select an Option</option>
                    <option value="related">Want to place an order?</option>
                    <option value="existing">Regarding an existing order</option>
                    <option value="other">Other</option>
                </select>
            </div>
        </div>
        
        <div class="con-field hidediv" id="showrelated" style="display: none;">
            <div class="title"><sup>*</sup><label>Related to:</label></div>
            <div class="field-body">
                <select name="orderplace_related" id="orderplace_related" required="">
                    <option value="">Please Select an Option</option>
                    <option value="Delivery Location">- Delivery Location</option>
                    <option value="When can we deliver">- When can we deliver</option>
                    <option value="Products">- Products</option>
                    <option value="Payments">- Payments</option>
                    <option value="Refund Policy">- Refund Policy</option>
                    <option value="Bulk Order">- Bulk Order</option>
                    <option value="Corporate enquiry">- Corporate enquiry</option>
                    <option value="Customized order">- Customized order</option>
                    <option value="Other">- Other</option>
                </select>
            </div>
        </div>
        <div class="hidediv hidediv" id="showexisting" style="display: none;">
            <div class="con-field " >
                <div class="title"><sup>*</sup><label>Related to:</label></div>
                <div class="field-body">
                    <select id="order_related" name="order_related" required="">	
                        <option value="">Please Select an Option</option>
                        <option value="Did you receive my order?">- Did you receive my order?</option>
                        <option value="When will my order get delivered?">- When will my order get delivered?</option>
                        <option value="Cancel my order">- Cancel my order</option>
                        <option value="Want a refund">- Want a refund</option>
                        <option value="Make a complaint">- Make a complaint</option>
                        <option value="Other">- Other</option>
                    </select>
                </div>
            </div>
            <div class="con-field" >
                <div class="title"><sup>*</sup><label>Order ID:</label></div>
                <input type="text" name="oid" id="oid" placeholder="Please Enter Order ID">
            </div>
        </div>
        <div class="con-field hidediv" id="showother" style="display: none;">
            <div class="title"> <sup>*</sup><label for="">Subject</label></div>
            <div class="field-body"><input type="text" name="subject" id="subject" placeholder="Enter Your Subject" required=""></div>
        </div>
        <div class="con-field">
            <div class="title"> <sup>*</sup><label for="">Name</label></div>
            <div class="field-body"><input  id="contact_name" placeholder="Name*" name="name" type="text" required=""></div>
        </div>
        <div class="con-field">
            <div class="title"> <sup>*</sup><label for="">Email</label></div>
            <div class="field-body"><input  id="contact_email" placeholder="Email*" name="email" type="text" required=""></div>
        </div>
        <div class="con-field">
            <div class="title"> <sup>*</sup><label for="">Mobile</label></div>
            <div class="field-body"><input  id="contact_mobile" placeholder="Mobile*" name="mobile" type="text" required=""></div>
        </div>
        
        <div class="con-field no-flex">
            <div class="title"> <sup>*</sup><label for="">Message:</label></div>
            <textarea  id="contact_message" placeholder="Message*" name="message" cols="30" rows="10" required="" style="width:100%"></textarea>
        </div>

        <div class="verify-captcha-block">
            <div class="verify">
                <div>
                    <input type="text" name="gencode" id="gencode" class="contactform_new_captcha" disabled="disabled" value="<?php echo $gencode; ?>" />
                    <a href="javascript:void(0)" class="reloadcaptcha"><i class="fa-solid fa-arrows-rotate"></i></a>
                </div>
            </div>
            <div class="captcha-down con-field">
                <div style="width:100%"><input  autocomplete="off" id="capcha_code" placeholder="Type the text*" equalto="#gencode" name="capchacode" type="text"></div>
                <input required="" type="hidden" name="gencode_verify" id="gencode_verify" value="<?php echo $gencode; ?>" />
            </div>
        </div>

        <div class="con-field flex-end">
            <button type="submit">Submit</button>
        </div>
    </div>
</div>


<div class="contact-rt">
    <div class="bulk">
      <div>Corporate/Bulk Order</div>
      <input type="button" value="click here">
    </div>
    <div class="bulk-add-con">
      <div class="bulk-add-head">Address</div>
      <div class="bulk-add"><i class="fa-sharp fa-solid fa-location-dot"></i> Los Angeles<br>CA 90040, USA</div>
    </div>
  </div>
</div>

<style type="text/css">
    .captchazone{border: 1px solid #a7a8a8; border-radius: 3px; padding: 5px; margin: 0!important; margin-bottom: 1em!important;}
    .fsmallcaptcha{width: 100%!important;}
    .reloadcaptcha{font-size: 25px!important; cursor: pointer;}
    /* .contactform_new_captcha { border: none; text-align: center; font-size: 30px!important; font-style: italic; font-family: 'sailecregular'; letter-spacing: 30px; font-weight: 900; color: #817e94; padding: 0; background-image: url(http://localhost/live-project/nfjp/public/images/capcha2.jpg); padding: 0!important; margin-top: 0!important; width: 100%; */
    
</style>

<script type="text/javascript">
    $(document).ready(function(){
      $("#contact_type").on('change', function(){

        $("#order_related").prop('required',false);
        $("#orderplace_related").prop('required',false);
        $("#oid").prop('required',false);
        $("#subject").prop('required',false);

        var demovalue = $(this).val();  
          $(".hidediv").hide();
          if(demovalue == "existing"){
            //$(".selcountry").hide();
            $("#order_related").prop('required',true);
            $("#oid").prop('required',true);
          }
          else if(demovalue == "related"){
            //$(".selcountry").show();
            $("#orderplace_related").prop('required',true);
          }else{
            $("#subject").prop('required',true);
          }
          $("#show"+demovalue).show();
      });
    }) ;

    $(".reloadcaptcha").on('click', function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '<?php echo e(route("reload-captcha")); ?>',
            method: 'get',
            success: function(data){
                console.log(data);
                    $('#gencode').val(data.vcode);
                    $('#gencode_verify').val(data.vcode);
            }
        });
    });

    $.validator.setDefaults({
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // validate the comment form when it is submitted


        $("#contactUs").validate({
            rules: {
                capcha_code: {
                    equalTo: '#gencode'
                }
            },
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
        });
    });
    // $('#contactUs').on('submit',function(){
    //     console.log('contact submitted')
    // });
   
    
</script> 

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.site.app', ['title' => $meta_title, 'meta_keyword' => $meta['meta_keyword'], 'meta_description' => $meta['meta_description']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u528937722/domains/yashrathi.com/public_html/resources/views/site/contact_us.blade.php ENDPATH**/ ?>