<!--header-->
<header class="index-heading">
    <section class="head11 flex">
        <div class="head11-left">
            <img src="<?php echo e(asset('images/flag.gif')); ?>" alt="" width="35" height="20">
            <h3>Gift Basket and Hampers Delivery in Brazil</h3>
        </div>
        <div class="head11-right">
            <a href="<?php echo e(route('bulk-orders')); ?>" alt="Corporate Orders">Corporate Orders</a>
        </div>
    </section>

    <section class="head2 flex">
        <div class="logo">
            <div class="logo-img" onclick="window.location.href='<?php echo e(url('/')); ?>'">
                <img src="<?php echo e(asset('images/sitelogo_new.webp')); ?>" alt="Logo" width="312" height="82">
            </div>
            <p>Send Gift Baskets & Hampers to Brazil</p>
        </div>

        <div class="search-bar2">
            <div class="search-bar2-main">
            <input type="text" name="searchKey" id="searchKey" placeholder="Search flowers, cakes etc." pattern=".{3,}" required="" title="3 characters minimum">
            <button type="submit" id="searchbtnn" aria-label="searchbtnn" class="search-btn serbtnnew"><i class="fa fa-search"></i></button>
            </div>
            <label id="searchAlert"></label>
        </div>

        <div class="head2-right flex">
            <a href="<?php echo e(route('contact-us')); ?>" class="head2-options" aria-label="contact us">
                <p>Contact Us</p>
            </a>
            <?php if(Auth::user()): ?>
                <a href="<?php echo e(route('users.logout')); ?>" class="head2-options" title="Logout" aria-label="login">
                <i class="fa-solid fa-right-from-bracket"></i>
                </a>
                <a href="<?php echo e(route('users.dashboard')); ?>" class="head2-options" title="Dashboard" aria-label="login">
                    <i class="fa-solid fa-user" title="Dashboard"></i>
                    <!-- <i class="fa-solid fa-briefcase"></i> -->
                </a>
                <a href="<?php echo e(route('order-status')); ?>" class="head2-options">
                    <i class="fa-solid fa-gift" alt="Track Order" aria-label="Track Order" title="Track Order"></i>

                </a>
            <?php else: ?>
                <a href="<?php echo e(route('users.login')); ?>" class="head2-options" title="Login" aria-label="login">
                    <i class="fa-solid fa-user"></i>
                </a>
                <a href="<?php echo e(route('order-status')); ?>" class="head2-options">
                    <i class="fa-solid fa-gift" alt="Track Order" aria-label="Track Order" title="Track Order"></i>
                </a>
            <?php endif; ?>
            <a href="<?php echo e(route('cart')); ?>" class="head2-options">
                <i class="fa-solid fa-cart-shopping" alt="Shopping Cart" aria-label="cart" title="cart"></i>
            </a>

        </div>
    </section>
</header>

<!--Navbar-->
<nav class="categories flex">
    <div class="view-cat" onClick="pc_menu()"><i class="fa-solid fa-bars"></i><i class="fa-solid fa-xmark" style="display:none;"></i>VIEW ALL CATEGORIES</div>
    <ul class="flex PC-menu">
    <li class="cat-menu "><a onClick="cat_menu_show()" class="category-btn">Categories<span class="fa fa-caret-down"></span></a>
    <div id="cat-mega-menu">
        <ul class="cat-menu-ul">
            <li><a  href="<?php echo e(url('/flowers')); ?>" title="Flowers">Flowers</a></li>
            <li><a href="<?php echo e(url('/cakes')); ?>" title="Cakes">Cakes</a></li>
            <li><a href="<?php echo e(url('/fruit-baskets')); ?>" title="Fruit Baskets">Fruit Baskets</a></li>
            <li><a href="<?php echo e(url('/plants')); ?>" title="Plants">Plants</a></li>
            <li><a href="<?php echo e(url('/hampers')); ?>" title="Hampers">Hampers</a></li>
        </ul>
        <ul class="cat-menu-ul">
            <li><a href="<?php echo e(url('/gourmet')); ?>" title="Gourmet Gift Baskets">Gourmet Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/wines')); ?>" title="Wine Gift Baskets">Wine Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/champagnes')); ?>" title="Champagne Gift Baskets">Champagne Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/chocolates')); ?>" title="Chocolate Gift Baskets">Chocolate Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/spa')); ?>" title="Spa Gift Baskets">Spa Gift Baskets</a></li>
        </ul>
        <ul class="cat-menu-ul">
            <li><a href="<?php echo e(url('/luxury')); ?>" title="Luxury Gift Baskets">Luxury Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/non-alcoholic')); ?>" title="Non-Alcoholic Gift Baskets">Non-Alcoholic Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/baked-goods')); ?>" title="Baked Goods Gift Baskets">Baked Goods Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/tea-coffee')); ?>" title="Tea & Coffee Gift Baskets">Tea & Coffee Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/meats-cheese')); ?>" title="Meat Gift Baskets">Meats & Cheese Gift Baskets</a></li>
        </ul>
        <ul class="cat-menu-ul">
            <li><a href="<?php echo e(url('/gift-baskets')); ?>" title="Gift Baskets">Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/corporate-gifts')); ?>" title="Corporate Gifts">Corporate Gifts</a></li>
            <li><a href="<?php echo e(url('/personalized')); ?>" title="Personalized Gift Baskets">Personalized Gift Baskets</a></li>
        </ul>
    </div>
    </li>
    <li class="oc-menu" onClick="abc()"><a href="#" class="occation-btn">Occasions<span class="fa fa-caret-down"></span></a>
    <div id="oc-mega-menu">
        <ul class="oc-menu-ul">
            <li><a href="<?php echo e(url('/anniversary')); ?>" title="Anniversary">Anniversary</a></li>
            <li><a href="<?php echo e(url('/birthday')); ?>" title="Birthday">Birthday</a></li>
            <li><a href="<?php echo e(url('/wedding')); ?>" title="Wedding">Wedding</a></li>
            <li><a href="<?php echo e(url('/congratulation')); ?>" title="Congratulation">Congratulation</a></li>
            <li><a href="<?php echo e(url('/condolence')); ?>" title="Condolence">Condolence</a></li>
        </ul>
        <ul class="oc-menu-ul">
            <li><a href="<?php echo e(url('/fathers-day')); ?>" title="Father's Day ">Father' Day</a></li>
            <li><a href="<?php echo e(url('/mothers-day')); ?>" title="Mother's Day">Mother's Day</a></li>
            <li><a href="<?php echo e(url('/christmas')); ?>" title="Christmas Gifts">Christmas Gifts</a></li>
            <li><a href="<?php echo e(url('/christmas-hampers')); ?>" title="Christmas Hampers">Christmas Hampers</a></li>
            <li><a href="<?php echo e(url('/easter-gifts')); ?>" title="Easter Gifts">Easter Gifts</a></li>
        </ul>
        <ul class="oc-menu-ul">
            <li><a href="<?php echo e(url('/new-years')); ?>" title="New Year Gifts">New Year Gifts</a></li>
            <li><a href="<?php echo e(url('/house-warming')); ?>" title="House Warming">House Warming</a></li>
            <li><a href="<?php echo e(url('/halloween')); ?>" title="Halloween Gifts ">Halloween Gifts</a></li>
            <li><a href="<?php echo e(url('/valentines-day ')); ?>" title="Valentine Day">Valentine Day</a></li>
        </ul>
        <ul class="oc-menu-ul">
            <li><a href="<?php echo e(url('/retirement')); ?>" title="Retirement Gift Baskets">Retirement Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/get-well-soon')); ?>" title="Get Well Soon Gift Baskets">Get Well Soon Gift Baskets</a></li>
            <li><a href="<?php echo e(url('/graduation')); ?>" title="Graduation Gift Baskets">Graduation Gift Baskets</a></li>
        </ul>
    </div>
    </li>
    <li class="rel-menu" onClick="abc()"><a href="#" class="occation-btn">Relations<span class="fa fa-caret-down"></span></a>
    <div id="rel-mega-menu">
        <ul class="rel-menu-ul">
            <li><a href="<?php echo e(url('/him')); ?>" title="Him">Him</a></li>
            <li><a href="<?php echo e(url('/her')); ?>" title="Her">Her</a></li>
        </ul>
        <ul class="rel-menu-ul">
            <li><a href="<?php echo e(url('/mom')); ?>" title="Mom">Mom</a></li>
            <li><a href="<?php echo e(url('/dad')); ?>" title="Dad">Dad</a></li>
        </ul>
        <ul class="rel-menu-ul">
            <li><a href="<?php echo e(url('/wife')); ?>" title="Wife">Wife</a></li>
            <li><a href="<?php echo e(url('/husband')); ?>" title="Husband">Husband</a></li>
        </ul>
        <ul class="rel-menu-ul">
            <li><a href="<?php echo e(url('/girlfriend')); ?>" title="Girlfriend">Girlfriend</a></li>
            <li><a href="<?php echo e(url('/boyfriend')); ?>" title="Boyfriend">Boyfriend</a></li>
        </ul>
    </div>
    </li>
    <li class=""><a class=""href="<?php echo e(url('/gourmet')); ?>" title="Gourmet Gifts">Gourmet Gifts</a></li>
    <li><a class="birthday-btn" href="<?php echo e(url('/wines')); ?>" title="Wine Hamper">Wine Hamper</a></li>
    <li><a class="wine-btn"href="<?php echo e(url('/flowers')); ?>" title="Flowers">Flowers</a></li>
    <li><a class="location-btn" href="<?php echo e(url('/')); ?>" title="Location">Where we deliver</a></li>
    <!-- <li  class="location-li"><a class="location-li-btn"href="<?php echo e(url('/')); ?>" title="Sale">Sale</a></li> -->
    </ul>
</nav>

<script>
    $('.serbtnnew').on('click', function() {
        if ($.trim($('#searchKey').val())  === '') {
            //alert('Please enter keywords, category etc');
            $("#searchAlert").css('display','block');
            $("#searchAlert").html("<i class='fa fa-exclamation-triangle'></i> Please Search by flowers, cakes, gifts etc.");
            setTimeout(function(){
            $("#searchAlert").html("");
            document.getElementById('searchAlert').style.display = 'none'
            }, 3000);
            return false;
        }else if($.trim($('#searchKey').val()).length < 3){
            $("#searchAlert").css('display','block');
            $("#searchAlert").html("<i class='fa fa-exclamation-triangle'></i> Please write minimum 3 characters");
            setTimeout(function(){
            $("#searchAlert").html("");
            document.getElementById('searchAlert').style.display = 'none'
            }, 3000);
            return false;
        } else {
            url = "<?php echo e(url('/search-by-keyword')); ?>/?query="+$.trim($('#searchKey').val());
            window.location.href = url;
            //alert(url);
        }
    });

    $('#searchKey').keypress(function(e){
        if(e.which == 13){//Enter key pressed
            $('.serbtnnew').click();//Trigger search button click event
        }
    });
</script>
<?php /**PATH C:\xampp\htdocs\Brazil\resources\views/partials/header.blade.php ENDPATH**/ ?>